/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.ExtendDeclaration;
import com.squareup.protoparser.Service;
import com.squareup.protoparser.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ProtoFile {
    private final String fileName;
    private final String packageName;
    private final List<String> dependencies;
    private final List<Type> types;
    private final List<Service> services;
    private final Map<String, Object> options;
    private final List<ExtendDeclaration> extendDeclarations;

    ProtoFile(String fileName, String packageName, List<String> dependencies, List<Type> types, List<Service> services, Map<String, Object> options, List<ExtendDeclaration> extendDeclarations) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (dependencies == null) {
            throw new NullPointerException("dependencies");
        }
        if (types == null) {
            throw new NullPointerException("types");
        }
        if (services == null) {
            throw new NullPointerException("services");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (extendDeclarations == null) {
            throw new NullPointerException("extendDeclarations");
        }
        this.fileName = fileName;
        this.packageName = packageName;
        this.dependencies = Collections.unmodifiableList(new ArrayList<String>(dependencies));
        this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
        this.services = Collections.unmodifiableList(new ArrayList<Service>(services));
        this.options = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(options));
        this.extendDeclarations = Collections.unmodifiableList(new ArrayList<ExtendDeclaration>(extendDeclarations));
    }

    public String getJavaPackage() {
        Object javaPackage = this.options.get("java_package");
        return javaPackage != null ? (String)javaPackage : this.packageName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<ExtendDeclaration> getExtendDeclarations() {
        return this.extendDeclarations;
    }

    public boolean equals(Object other) {
        if (other instanceof ProtoFile) {
            ProtoFile that = (ProtoFile)other;
            return ProtoFile.eq(this.fileName, that.fileName) && ProtoFile.eq(this.packageName, that.packageName) && ProtoFile.eq(this.dependencies, that.dependencies) && ProtoFile.eq(this.types, that.types) && ProtoFile.eq(this.services, that.services) && ProtoFile.eq(this.options, that.options) && ProtoFile.eq(this.extendDeclarations, that.extendDeclarations);
        }
        return false;
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("fileName: ").append(this.fileName).append('\n');
        result.append("packageName: ").append(this.packageName).append('\n');
        for (Map.Entry<String, Object> option : this.options.entrySet()) {
            result.append("option ").append(option.getKey()).append(" = ").append(option.getValue()).append('\n');
        }
        for (String dependency : this.dependencies) {
            result.append("import ").append(dependency).append('\n');
        }
        for (Type type : this.types) {
            result.append(type).append('\n');
        }
        for (Service service : this.services) {
            result.append(service).append('\n');
        }
        for (ExtendDeclaration extendDeclaration : this.extendDeclarations) {
            result.append(extendDeclaration).append('\n');
        }
        return result.toString();
    }
}

