/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.Extensions;
import com.squareup.protoparser.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MessageType
implements Type {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Field> fields;
    private final List<Type> nestedTypes;
    private final List<Extensions> extensions;

    MessageType(String name, String fqname, String documentation, List<Field> fields, List<Type> nestedTypes, List<Extensions> extensions) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        if (nestedTypes == null) {
            throw new NullPointerException("nestedTypes");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions");
        }
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.fields = Collections.unmodifiableList(new ArrayList<Field>(fields));
        this.nestedTypes = Collections.unmodifiableList(new ArrayList<Type>(nestedTypes));
        this.extensions = Collections.unmodifiableList(new ArrayList<Extensions>(extensions));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Type> getNestedTypes() {
        return this.nestedTypes;
    }

    public List<Extensions> getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object other) {
        if (other instanceof MessageType) {
            MessageType that = (MessageType)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.fields.equals(that.fields) && this.nestedTypes.equals(that.nestedTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (Field field : this.fields) {
            result.append("\n  ").append(field);
        }
        for (Type type : this.nestedTypes) {
            result.append(type).append("\n");
        }
        return result.toString();
    }

    public static final class Field {
        private final Label label;
        private final String type;
        private final String name;
        private final int tag;
        private final Map<String, Object> extensions;
        private final String documentation;

        Field(Label label, String type, String name, int tag, String documentation, Map<String, Object> extensions) {
            if (label == null) {
                throw new NullPointerException("label");
            }
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (extensions == null) {
                throw new NullPointerException("extensions");
            }
            this.label = label;
            this.type = type;
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
            this.extensions = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(extensions));
        }

        public Label getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return "true".equals(this.extensions.get("deprecated"));
        }

        public String getDefault() {
            return (String)this.extensions.get("default");
        }

        public boolean equals(Object other) {
            if (other instanceof Field) {
                Field that = (Field)other;
                return this.label.equals((Object)that.label) && this.type.equals(that.type) && this.name.equals(that.name) && this.tag == that.tag && this.extensions.equals(that.extensions) && this.documentation.equals(that.documentation);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + 37 * this.type.hashCode();
        }

        public String toString() {
            return String.format("%s %s %s = %d %s", new Object[]{this.label, this.type, this.name, this.tag, this.extensions});
        }
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED;

    }
}

