(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'fs', 'okio-parent-okio-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('fs'), require('okio-parent-okio-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'okio-parent-okio-nodefilesystem-js-legacy'.");
    }if (typeof fs === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem-js-legacy'. Its dependency 'fs' was not found. Please, check whether 'fs' is loaded prior to 'okio-parent-okio-nodefilesystem-js-legacy'.");
    }if (typeof this['okio-parent-okio-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem-js-legacy'. Its dependency 'okio-parent-okio-js-legacy' was not found. Please, check whether 'okio-parent-okio-js-legacy' is loaded prior to 'okio-parent-okio-nodefilesystem-js-legacy'.");
    }root['okio-parent-okio-nodefilesystem-js-legacy'] = factory(typeof this['okio-parent-okio-nodefilesystem-js-legacy'] === 'undefined' ? {} : this['okio-parent-okio-nodefilesystem-js-legacy'], kotlin, fs, this['okio-parent-okio-js-legacy']);
  }
}(this, function (_, Kotlin, $module$fs, $module$okio_parent_okio_js_legacy) {
  'use strict';
  var L0 = Kotlin.Long.ZERO;
  var writeSync = $module$fs.writeSync;
  var equals = Kotlin.equals;
  var IOException_init = $module$okio_parent_okio_js_legacy.okio.IOException_init_pdl1vj$;
  var Timeout = $module$okio_parent_okio_js_legacy.okio.Timeout;
  var closeSync = $module$fs.closeSync;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Sink = $module$okio_parent_okio_js_legacy.okio.Sink;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var readSync = $module$fs.readSync;
  var numberToInt = Kotlin.numberToInt;
  var L_1 = Kotlin.Long.NEG_ONE;
  var Source = $module$okio_parent_okio_js_legacy.okio.Source;
  var fstatSync = $module$fs.fstatSync;
  var numberToLong = Kotlin.numberToLong;
  var ftruncateSync = $module$fs.ftruncateSync;
  var FileHandle = $module$okio_parent_okio_js_legacy.okio.FileHandle;
  var realpathSync = $module$fs.realpathSync;
  var Path = $module$okio_parent_okio_js_legacy.okio.Path;
  var Throwable = Error;
  var statSync = $module$fs.statSync;
  var FileMetadata = $module$okio_parent_okio_js_legacy.okio.FileMetadata;
  var opendirSync = $module$fs.opendirSync;
  var sort = Kotlin.kotlin.collections.sort_4wi501$;
  var FileNotFoundException = $module$okio_parent_okio_js_legacy.okio.FileNotFoundException;
  var openSync = $module$fs.openSync;
  var mkdirSync = $module$fs.mkdirSync;
  var renameSync = $module$fs.renameSync;
  var unlinkSync = $module$fs.unlinkSync;
  var rmdirSync = $module$fs.rmdirSync;
  var FileSystem = $module$okio_parent_okio_js_legacy.okio.FileSystem;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  NodeJsFileHandle.prototype = Object.create(FileHandle.prototype);
  NodeJsFileHandle.prototype.constructor = NodeJsFileHandle;
  NodeJsFileSystem.prototype = Object.create(FileSystem.prototype);
  NodeJsFileSystem.prototype.constructor = NodeJsFileSystem;
  function FileSink(fd) {
    this.fd_0 = fd;
    this.closed_0 = false;
  }
  FileSink.prototype.write_u27jpl$ = function (source, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (!(source.size.compareTo_11rb$(byteCount) >= 0)) {
      var message_0 = 'source.size=' + source.size.toString() + ' < byteCount=' + byteCount.toString();
      throw IllegalArgumentException_init(message_0.toString());
    }if (!!this.closed_0) {
      var message_1 = 'closed';
      throw IllegalStateException_init(message_1.toString());
    }var data = source.readByteArray_s8cxhz$(byteCount);
    var writtenByteCount = writeSync(this.fd_0, data);
    if (!equals(Kotlin.Long.fromNumber(writtenByteCount), byteCount)) {
      throw IOException_init('expected ' + byteCount.toString() + ' but was ' + writtenByteCount);
    }};
  FileSink.prototype.flush = function () {
  };
  FileSink.prototype.timeout = function () {
    return Timeout.Companion.NONE;
  };
  FileSink.prototype.close = function () {
    if (this.closed_0)
      return;
    this.closed_0 = true;
    closeSync(this.fd_0);
  };
  FileSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSink',
    interfaces: [Sink]
  };
  function FileSource(fd) {
    this.fd_0 = fd;
    this.position__0 = L0;
    this.closed_0 = false;
  }
  FileSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (!!this.closed_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }var data = new Int8Array(byteCount.toInt());
    var readByteCount = numberToInt(readSync(this.fd_0, data, 0.0, byteCount.toNumber(), this.position__0.toNumber()));
    if (readByteCount === 0)
      return L_1;
    this.position__0 = this.position__0.add(Kotlin.Long.fromInt(readByteCount));
    sink.write_mj6st8$(data, 0, readByteCount);
    return Kotlin.Long.fromInt(readByteCount);
  };
  FileSource.prototype.timeout = function () {
    return Timeout.Companion.NONE;
  };
  FileSource.prototype.close = function () {
    if (this.closed_0)
      return;
    this.closed_0 = true;
    closeSync(this.fd_0);
  };
  FileSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSource',
    interfaces: [Source]
  };
  function NodeJsFileHandle(fd, readWrite) {
    FileHandle.call(this, readWrite);
    this.fd_0 = fd;
  }
  NodeJsFileHandle.prototype.size = function () {
    var stats = fstatSync(this.fd_0);
    return numberToLong(stats.size);
  };
  NodeJsFileHandle.prototype.protectedRead_4m9kcn$ = function (fileOffset, array, arrayOffset, byteCount) {
    var readByteCount = numberToInt(readSync(this.fd_0, array, arrayOffset, byteCount, fileOffset.toNumber()));
    if (readByteCount === 0)
      return -1;
    return readByteCount;
  };
  NodeJsFileHandle.prototype.protectedWrite_4m9kcn$ = function (fileOffset, array, arrayOffset, byteCount) {
    var writtenByteCount = writeSync(this.fd_0, array, arrayOffset, byteCount, fileOffset.toNumber());
    if (numberToInt(writtenByteCount) !== byteCount) {
      throw IOException_init('expected ' + byteCount + ' but was ' + writtenByteCount);
    }};
  NodeJsFileHandle.prototype.protectedFlush = function () {
  };
  NodeJsFileHandle.prototype.protectedResize_s8cxhz$ = function (size) {
    ftruncateSync(this.fd_0, size.toNumber());
  };
  NodeJsFileHandle.prototype.protectedClose = function () {
    closeSync(this.fd_0);
  };
  NodeJsFileHandle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NodeJsFileHandle',
    interfaces: [FileHandle]
  };
  function NodeJsFileSystem() {
    NodeJsFileSystem_instance = this;
    FileSystem.call(this);
    this.S_IFMT_0 = 61440;
    this.S_IFREG_0 = 32768;
    this.S_IFDIR_0 = 16384;
  }
  NodeJsFileSystem.prototype.canonicalize_awoskx$ = function (path) {
    try {
      var canonicalPath = realpathSync(path.toString());
      return Path.Companion.toPath_pdl1vz$(canonicalPath.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.metadataOrNull_awoskx$ = function (path) {
    var tmp$;
    try {
      tmp$ = statSync(path.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        if (this.get_errorCode_0(e) == 'ENOENT')
          return null;
        throw IOException_init(e.message);
      } else
        throw e;
    }
    var stat = tmp$;
    return new FileMetadata((numberToInt(stat.mode) & this.S_IFMT_0) === this.S_IFREG_0, (numberToInt(stat.mode) & this.S_IFMT_0) === this.S_IFDIR_0, numberToLong(stat.size), numberToLong(stat.ctimeMs), numberToLong(stat.mtimeMs), numberToLong(stat.atimeMs));
  };
  NodeJsFileSystem.prototype.get_errorCode_0 = function ($receiver) {
    return $receiver.code;
  };
  NodeJsFileSystem.prototype.list_awoskx$ = function (dir) {
    var tmp$;
    try {
      var opendir = opendirSync(dir.toString());
      try {
        var result = ArrayList_init();
        while (true) {
          tmp$ = opendir.readSync();
          if (tmp$ == null) {
            break;
          }var dirent = tmp$;
          var element = dir.div_61zpoe$(dirent.name);
          result.add_11rb$(element);
        }
        sort(result);
        return result;
      }finally {
        opendir.closeSync();
      }
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.openReadOnly_awoskx$ = function (file) {
    var fd = this.openFd_0(file, 'r');
    return new NodeJsFileHandle(fd, false);
  };
  NodeJsFileSystem.prototype.openReadWrite_awoskx$ = function (file) {
    var tmp$;
    if (equals(Path.Companion.DIRECTORY_SEPARATOR, '\\')) {
      try {
        tmp$ = this.openFd_0(file, 'r+');
      } catch (e) {
        if (Kotlin.isType(e, FileNotFoundException)) {
          tmp$ = this.openFd_0(file, 'wx+');
        } else
          throw e;
      }
    } else {
      tmp$ = this.openFd_0(file, 'a+');
    }
    var fd = tmp$;
    return new NodeJsFileHandle(fd, true);
  };
  NodeJsFileSystem.prototype.source_awoskx$ = function (file) {
    var fd = this.openFd_0(file, 'r');
    return new FileSource(fd);
  };
  NodeJsFileSystem.prototype.sink_awoskx$ = function (file) {
    var fd = this.openFd_0(file, 'w');
    return new FileSink(fd);
  };
  NodeJsFileSystem.prototype.appendingSink_awoskx$ = function (file) {
    var fd = this.openFd_0(file, 'a');
    return new FileSink(fd);
  };
  NodeJsFileSystem.prototype.openFd_0 = function (file, flags) {
    try {
      return openSync(file.toString(), flags);
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.createDirectory_awoskx$ = function (dir) {
    try {
      mkdirSync(dir.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.atomicMove_vhmyk6$ = function (source, target) {
    try {
      renameSync(source.toString(), target.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.delete_awoskx$ = function (path) {
    try {
      unlinkSync(path.toString());
      return;
    } catch (e) {
      if (!Kotlin.isType(e, Throwable))
        throw e;
    }
    try {
      rmdirSync(path.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.toIOException_0 = function ($receiver) {
    var tmp$;
    if (equals(this.get_errorCode_0($receiver), 'ENOENT'))
      tmp$ = new FileNotFoundException($receiver.message);
    else
      tmp$ = IOException_init($receiver.message);
    return tmp$;
  };
  NodeJsFileSystem.prototype.toString = function () {
    return 'NodeJsSystemFileSystem';
  };
  NodeJsFileSystem.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NodeJsFileSystem',
    interfaces: [FileSystem]
  };
  var NodeJsFileSystem_instance = null;
  function NodeJsFileSystem_getInstance() {
    if (NodeJsFileSystem_instance === null) {
      new NodeJsFileSystem();
    }return NodeJsFileSystem_instance;
  }
  var package$okio = _.okio || (_.okio = {});
  package$okio.FileSink = FileSink;
  package$okio.FileSource = FileSource;
  package$okio.NodeJsFileHandle = NodeJsFileHandle;
  Object.defineProperty(package$okio, 'NodeJsFileSystem', {
    get: NodeJsFileSystem_getInstance
  });
  Kotlin.defineModule('okio-parent-okio-nodefilesystem-js-legacy', _);
  return _;
}));

//# sourceMappingURL=okio-parent-okio-nodefilesystem-js-legacy.js.map
