(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'fs', 'okio-parent-okio'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('fs'), require('okio-parent-okio'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'okio-parent-okio-nodefilesystem'.");
    }if (typeof fs === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem'. Its dependency 'fs' was not found. Please, check whether 'fs' is loaded prior to 'okio-parent-okio-nodefilesystem'.");
    }if (typeof this['okio-parent-okio'] === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-nodefilesystem'. Its dependency 'okio-parent-okio' was not found. Please, check whether 'okio-parent-okio' is loaded prior to 'okio-parent-okio-nodefilesystem'.");
    }root['okio-parent-okio-nodefilesystem'] = factory(typeof this['okio-parent-okio-nodefilesystem'] === 'undefined' ? {} : this['okio-parent-okio-nodefilesystem'], kotlin, fs, this['okio-parent-okio']);
  }
}(this, function (_, Kotlin, $module$fs, $module$okio_parent_okio) {
  'use strict';
  var L0 = Kotlin.Long.ZERO;
  var toTypedArray = Kotlin.kotlin.collections.toTypedArray_964n91$;
  var writeSync = $module$fs.writeSync;
  var numberToLong = Kotlin.numberToLong;
  var equals = Kotlin.equals;
  var IOException_init = $module$okio_parent_okio.okio.IOException_init_pdl1vj$;
  var Timeout = $module$okio_parent_okio.okio.Timeout;
  var closeSync = $module$fs.closeSync;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Sink = $module$okio_parent_okio.okio.Sink;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var readSync = $module$fs.readSync;
  var numberToInt = Kotlin.numberToInt;
  var L_1 = Kotlin.Long.NEG_ONE;
  var fstatSync = $module$fs.fstatSync;
  var Source = $module$okio_parent_okio.okio.Source;
  var Cursor = $module$okio_parent_okio.okio.Cursor;
  var realpathSync = $module$fs.realpathSync;
  var Path = $module$okio_parent_okio.okio.Path;
  var Throwable = Error;
  var statSync = $module$fs.statSync;
  var FileMetadata = $module$okio_parent_okio.okio.FileMetadata;
  var opendirSync = $module$fs.opendirSync;
  var sort = Kotlin.kotlin.collections.sort_4wi501$;
  var openSync = $module$fs.openSync;
  var mkdirSync = $module$fs.mkdirSync;
  var renameSync = $module$fs.renameSync;
  var unlinkSync = $module$fs.unlinkSync;
  var rmdirSync = $module$fs.rmdirSync;
  var FileNotFoundException = $module$okio_parent_okio.okio.FileNotFoundException;
  var FileSystem = $module$okio_parent_okio.okio.FileSystem;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  NodeJsFileSystem.prototype = Object.create(FileSystem.prototype);
  NodeJsFileSystem.prototype.constructor = NodeJsFileSystem;
  function FileSink(fd) {
    this.fd_0 = fd;
    this.closed_0 = false;
  }
  FileSink.prototype.write_u27jpl$ = function (source, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (!(source.size.compareTo_11rb$(byteCount) >= 0)) {
      var message_0 = 'source.size=' + source.size.toString() + ' < byteCount=' + byteCount.toString();
      throw IllegalArgumentException_init(message_0.toString());
    }if (!!this.closed_0) {
      var message_1 = 'closed';
      throw IllegalStateException_init(message_1.toString());
    }var data = new Uint8Array(byteCount.toInt());
    data.set(toTypedArray(source.readByteArray()));
    var writtenByteCount = writeSync(this.fd_0, data);
    if (!equals(numberToLong(writtenByteCount), byteCount)) {
      throw IOException_init('expected ' + byteCount.toString() + ' but was ' + writtenByteCount.toString());
    }};
  FileSink.prototype.flush = function () {
  };
  FileSink.prototype.timeout = function () {
    return Timeout.Companion.NONE;
  };
  FileSink.prototype.close = function () {
    if (this.closed_0)
      return;
    this.closed_0 = true;
    closeSync(this.fd_0);
  };
  FileSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSink',
    interfaces: [Sink]
  };
  function FileSource(fd) {
    this.fd_0 = fd;
    this.position__0 = L0;
    this.closed_0 = false;
  }
  FileSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (!!this.closed_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }var data = new Uint8Array(byteCount.toInt());
    var readByteCount = numberToInt(readSync(this.fd_0, data, 0, byteCount, this.position__0.toNumber()));
    if (readByteCount === 0)
      return L_1;
    this.position__0 = this.position__0.add(Kotlin.Long.fromInt(readByteCount));
    for (var i = 0; i < readByteCount; i++) {
      sink.writeByte_za3lpa$(data[i]);
    }
    return Kotlin.Long.fromInt(readByteCount);
  };
  FileSource.prototype.timeout = function () {
    return Timeout.Companion.NONE;
  };
  FileSource.prototype.cursor = function () {
    return this;
  };
  FileSource.prototype.position = function () {
    if (!!this.closed_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }return this.position__0;
  };
  FileSource.prototype.size = function () {
    if (!!this.closed_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }var stats = fstatSync(this.fd_0);
    return numberToLong(stats.size);
  };
  FileSource.prototype.seek_s8cxhz$ = function (position) {
    if (!!this.closed_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.position__0 = position;
  };
  FileSource.prototype.close = function () {
    if (this.closed_0)
      return;
    this.closed_0 = true;
    closeSync(this.fd_0);
  };
  FileSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSource',
    interfaces: [Cursor, Source]
  };
  function NodeJsFileSystem() {
    NodeJsFileSystem_instance = this;
    FileSystem.call(this);
    this.S_IFMT_0 = 61440;
    this.S_IFREG_0 = 32768;
    this.S_IFDIR_0 = 16384;
  }
  NodeJsFileSystem.prototype.canonicalize_awoskx$ = function (path) {
    try {
      var canonicalPath = realpathSync(path.toString());
      return Path.Companion.toPath_pdl1vz$(canonicalPath.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.metadataOrNull_awoskx$ = function (path) {
    var tmp$;
    try {
      tmp$ = statSync(path.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        if (this.get_errorCode_0(e) == 'ENOENT')
          return null;
        throw IOException_init(e.message);
      } else
        throw e;
    }
    var stat = tmp$;
    return new FileMetadata((numberToInt(stat.mode) & this.S_IFMT_0) === this.S_IFREG_0, (numberToInt(stat.mode) & this.S_IFMT_0) === this.S_IFDIR_0, numberToLong(stat.size), numberToLong(stat.ctimeMs), numberToLong(stat.mtimeMs), numberToLong(stat.atimeMs));
  };
  NodeJsFileSystem.prototype.get_errorCode_0 = function ($receiver) {
    return $receiver.code;
  };
  NodeJsFileSystem.prototype.list_awoskx$ = function (dir) {
    var tmp$;
    try {
      var opendir = opendirSync(dir.toString());
      try {
        var result = ArrayList_init();
        while (true) {
          tmp$ = opendir.readSync();
          if (tmp$ == null) {
            break;
          }var dirent = tmp$;
          var element = dir.div_61zpoe$(dirent.name);
          result.add_11rb$(element);
        }
        sort(result);
        return result;
      }finally {
        opendir.closeSync();
      }
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.source_awoskx$ = function (file) {
    try {
      var fd = openSync(file.toString(), 'r');
      return new FileSource(fd);
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.sink_awoskx$ = function (file) {
    try {
      var fd = openSync(file.toString(), 'w');
      return new FileSink(fd);
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.appendingSink_awoskx$ = function (file) {
    try {
      var fd = openSync(file.toString(), 'a');
      return new FileSink(fd);
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.createDirectory_awoskx$ = function (dir) {
    try {
      mkdirSync(dir.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.atomicMove_vhmyk6$ = function (source, target) {
    try {
      renameSync(source.toString(), target.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.delete_awoskx$ = function (path) {
    try {
      unlinkSync(path.toString());
      return;
    } catch (e) {
      if (!Kotlin.isType(e, Throwable))
        throw e;
    }
    try {
      rmdirSync(path.toString());
    } catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw this.toIOException_0(e);
      } else
        throw e;
    }
  };
  NodeJsFileSystem.prototype.toIOException_0 = function ($receiver) {
    var tmp$;
    if (equals(this.get_errorCode_0($receiver), 'ENOENT'))
      tmp$ = new FileNotFoundException($receiver.message);
    else
      tmp$ = IOException_init($receiver.message);
    return tmp$;
  };
  NodeJsFileSystem.prototype.toString = function () {
    return 'NodeJsSystemFileSystem';
  };
  NodeJsFileSystem.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NodeJsFileSystem',
    interfaces: [FileSystem]
  };
  var NodeJsFileSystem_instance = null;
  function NodeJsFileSystem_getInstance() {
    if (NodeJsFileSystem_instance === null) {
      new NodeJsFileSystem();
    }return NodeJsFileSystem_instance;
  }
  var package$okio = _.okio || (_.okio = {});
  package$okio.FileSink = FileSink;
  package$okio.FileSource = FileSource;
  Object.defineProperty(package$okio, 'NodeJsFileSystem', {
    get: NodeJsFileSystem_getInstance
  });
  Kotlin.defineModule('okio-parent-okio-nodefilesystem', _);
  return _;
}));

//# sourceMappingURL=okio-parent-okio-nodefilesystem.js.map
