//[okio](../../../index.md)/[okio](../index.md)/[ForwardingFileSystem](index.md)/[onPathParameter](on-path-parameter.md)

# onPathParameter

[common]\
open fun [onPathParameter](on-path-parameter.md)(path: [Path](../-path/index.md), functionName: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), parameterName: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Path](../-path/index.md)

Invoked each time a path is passed as a parameter to this file system. This returns the path to pass to [delegate](delegate.md), which should be [path](on-path-parameter.md) itself or a path on [delegate](delegate.md) that corresponds to it.

Subclasses may override this to log accesses, fail on unexpected accesses, or map paths across file systems.

The base implementation returns [path](on-path-parameter.md).

Note that this function will be called twice for calls to [atomicMove](atomic-move.md); once for the source file and once for the target file.

#### Return

the path to pass to [delegate](delegate.md) for the same parameter.

#### Parameters

common

| | |
|---|---|
| path | the path passed to any of the functions of this. |
| functionName | a string like &quot;canonicalize&quot;, &quot;metadataOrNull&quot;, or &quot;appendingSink&quot;. |
| parameterName | a string like &quot;path&quot;, &quot;file&quot;, &quot;source&quot;, or &quot;target&quot;. |