/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.Validity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010,\u001a\u00020-H\u0016J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\u0007H\u00c6\u0003J\u0015\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u00c6\u0003J\t\u00102\u001a\u00020\fH\u00c6\u0003J\u0015\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u00c6\u0003J\t\u00104\u001a\u00020\u000fH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u00c6\u0003J\u008f\u0001\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006="}, d2={"Lokhttp3/tls/internal/der/TbsCertificate;", "", "version", "", "serialNumber", "Ljava/math/BigInteger;", "signature", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "issuer", "", "Lokhttp3/tls/internal/der/AttributeTypeAndValue;", "validity", "Lokhttp3/tls/internal/der/Validity;", "subject", "subjectPublicKeyInfo", "Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;", "issuerUniqueID", "Lokhttp3/tls/internal/der/BitString;", "subjectUniqueID", "extensions", "Lokhttp3/tls/internal/der/Extension;", "<init>", "(JLjava/math/BigInteger;Lokhttp3/tls/internal/der/AlgorithmIdentifier;Ljava/util/List;Lokhttp3/tls/internal/der/Validity;Ljava/util/List;Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;Lokhttp3/tls/internal/der/BitString;Lokhttp3/tls/internal/der/BitString;Ljava/util/List;)V", "getVersion", "()J", "getSerialNumber", "()Ljava/math/BigInteger;", "getSignature", "()Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "getIssuer", "()Ljava/util/List;", "getValidity", "()Lokhttp3/tls/internal/der/Validity;", "getSubject", "getSubjectPublicKeyInfo", "()Lokhttp3/tls/internal/der/SubjectPublicKeyInfo;", "getIssuerUniqueID", "()Lokhttp3/tls/internal/der/BitString;", "getSubjectUniqueID", "getExtensions", "signatureAlgorithmName", "", "getSignatureAlgorithmName", "()Ljava/lang/String;", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "toString", "okhttp-tls"})
public final class TbsCertificate {
    private final long version;
    @NotNull
    private final BigInteger serialNumber;
    @NotNull
    private final AlgorithmIdentifier signature;
    @NotNull
    private final List<List<AttributeTypeAndValue>> issuer;
    @NotNull
    private final Validity validity;
    @NotNull
    private final List<List<AttributeTypeAndValue>> subject;
    @NotNull
    private final SubjectPublicKeyInfo subjectPublicKeyInfo;
    @Nullable
    private final BitString issuerUniqueID;
    @Nullable
    private final BitString subjectUniqueID;
    @NotNull
    private final List<Extension> extensions;

    public TbsCertificate(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.version = version;
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.issuerUniqueID = issuerUniqueID;
        this.subjectUniqueID = subjectUniqueID;
        this.extensions = extensions;
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Validity getValidity() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> getSubject() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final String getSignatureAlgorithmName() {
        String string;
        String string2 = this.signature.getAlgorithm();
        if (Intrinsics.areEqual((Object)string2, (Object)"1.2.840.113549.1.1.11")) {
            string = "SHA256WithRSA";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"1.2.840.10045.4.3.2")) {
            string = "SHA256withECDSA";
        } else {
            throw new IllegalStateException(("unexpected signature algorithm: " + this.signature.getAlgorithm()).toString());
        }
        return string;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (int)this.version;
        result = 31 * result + this.serialNumber.hashCode();
        result = 31 * result + this.signature.hashCode();
        result = 31 * result + ((Object)this.issuer).hashCode();
        result = 31 * result + this.validity.hashCode();
        result = 31 * result + ((Object)this.subject).hashCode();
        result = 31 * result + this.subjectPublicKeyInfo.hashCode();
        BitString bitString = this.issuerUniqueID;
        result = 31 * result + (bitString != null ? bitString.hashCode() : 0);
        BitString bitString2 = this.subjectUniqueID;
        result = 31 * result + (bitString2 != null ? bitString2.hashCode() : 0);
        result = 31 * result + ((Object)this.extensions).hashCode();
        return result;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final BigInteger component2() {
        return this.serialNumber;
    }

    @NotNull
    public final AlgorithmIdentifier component3() {
        return this.signature;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component4() {
        return this.issuer;
    }

    @NotNull
    public final Validity component5() {
        return this.validity;
    }

    @NotNull
    public final List<List<AttributeTypeAndValue>> component6() {
        return this.subject;
    }

    @NotNull
    public final SubjectPublicKeyInfo component7() {
        return this.subjectPublicKeyInfo;
    }

    @Nullable
    public final BitString component8() {
        return this.issuerUniqueID;
    }

    @Nullable
    public final BitString component9() {
        return this.subjectUniqueID;
    }

    @NotNull
    public final List<Extension> component10() {
        return this.extensions;
    }

    @NotNull
    public final TbsCertificate copy(long version, @NotNull BigInteger serialNumber, @NotNull AlgorithmIdentifier signature, @NotNull List<? extends List<AttributeTypeAndValue>> issuer, @NotNull Validity validity, @NotNull List<? extends List<AttributeTypeAndValue>> subject, @NotNull SubjectPublicKeyInfo subjectPublicKeyInfo, @Nullable BitString issuerUniqueID, @Nullable BitString subjectUniqueID, @NotNull List<Extension> extensions) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)validity, (String)"validity");
        Intrinsics.checkNotNullParameter(subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        return new TbsCertificate(version, serialNumber, signature, issuer, validity, subject, subjectPublicKeyInfo, issuerUniqueID, subjectUniqueID, extensions);
    }

    public static /* synthetic */ TbsCertificate copy$default(TbsCertificate tbsCertificate, long l, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier, List list, Validity validity, List list2, SubjectPublicKeyInfo subjectPublicKeyInfo, BitString bitString, BitString bitString2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            l = tbsCertificate.version;
        }
        if ((n & 2) != 0) {
            bigInteger = tbsCertificate.serialNumber;
        }
        if ((n & 4) != 0) {
            algorithmIdentifier = tbsCertificate.signature;
        }
        if ((n & 8) != 0) {
            list = tbsCertificate.issuer;
        }
        if ((n & 0x10) != 0) {
            validity = tbsCertificate.validity;
        }
        if ((n & 0x20) != 0) {
            list2 = tbsCertificate.subject;
        }
        if ((n & 0x40) != 0) {
            subjectPublicKeyInfo = tbsCertificate.subjectPublicKeyInfo;
        }
        if ((n & 0x80) != 0) {
            bitString = tbsCertificate.issuerUniqueID;
        }
        if ((n & 0x100) != 0) {
            bitString2 = tbsCertificate.subjectUniqueID;
        }
        if ((n & 0x200) != 0) {
            list3 = tbsCertificate.extensions;
        }
        return tbsCertificate.copy(l, bigInteger, algorithmIdentifier, list, validity, list2, subjectPublicKeyInfo, bitString, bitString2, list3);
    }

    @NotNull
    public String toString() {
        return "TbsCertificate(version=" + this.version + ", serialNumber=" + this.serialNumber + ", signature=" + this.signature + ", issuer=" + this.issuer + ", validity=" + this.validity + ", subject=" + this.subject + ", subjectPublicKeyInfo=" + this.subjectPublicKeyInfo + ", issuerUniqueID=" + this.issuerUniqueID + ", subjectUniqueID=" + this.subjectUniqueID + ", extensions=" + this.extensions + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TbsCertificate)) {
            return false;
        }
        TbsCertificate tbsCertificate = (TbsCertificate)other;
        if (this.version != tbsCertificate.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serialNumber, (Object)tbsCertificate.serialNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signature, (Object)tbsCertificate.signature)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.issuer, tbsCertificate.issuer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.validity, (Object)tbsCertificate.validity)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subject, tbsCertificate.subject)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subjectPublicKeyInfo, (Object)tbsCertificate.subjectPublicKeyInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.issuerUniqueID, (Object)tbsCertificate.issuerUniqueID)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subjectUniqueID, (Object)tbsCertificate.subjectUniqueID)) {
            return false;
        }
        return Intrinsics.areEqual(this.extensions, tbsCertificate.extensions);
    }
}

