/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0014\u001a\u00020\u00152\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0016J%\u0010\n\u001a\u00020\u00152\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lokhttp3/tls/internal/InsecureAndroidTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "delegate", "insecureHosts", "", "", "<init>", "(Ljavax/net/ssl/X509TrustManager;Ljava/util/List;)V", "checkServerTrustedMethod", "Ljava/lang/reflect/Method;", "checkServerTrusted", "Ljava/security/cert/Certificate;", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "host", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "checkClientTrusted", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)Ljava/lang/Void;", "okhttp-tls"})
public final class InsecureAndroidTrustManager
implements X509TrustManager {
    @NotNull
    private final X509TrustManager delegate;
    @NotNull
    private final List<String> insecureHosts;
    @Nullable
    private final Method checkServerTrustedMethod;

    public InsecureAndroidTrustManager(@NotNull X509TrustManager delegate, @NotNull List<String> insecureHosts) {
        Object object;
        InsecureAndroidTrustManager insecureAndroidTrustManager;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        this.delegate = delegate;
        this.insecureHosts = insecureHosts;
        InsecureAndroidTrustManager insecureAndroidTrustManager2 = this;
        try {
            insecureAndroidTrustManager = insecureAndroidTrustManager2;
            object = new Class[]{X509Certificate[].class, String.class, String.class};
            object = this.delegate.getClass().getMethod("checkServerTrusted", (Class<?>)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            insecureAndroidTrustManager = insecureAndroidTrustManager2;
            object = null;
        }
        insecureAndroidTrustManager.checkServerTrustedMethod = object;
    }

    @NotNull
    public final List<Certificate> checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.insecureHosts.contains(host)) {
            return CollectionsKt.emptyList();
        }
        try {
            Method method = this.checkServerTrustedMethod;
            if (method == null) {
                throw new CertificateException("Failed to call checkServerTrusted");
            }
            Method method2 = method;
            Object[] objectArray = new Object[]{chain, authType, host};
            Object object = method2.invoke((Object)this.delegate, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.security.cert.Certificate>");
            return (List)object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.delegate.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"getAcceptedIssuers(...)");
        return x509CertificateArray;
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }
}

