/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.DerHeader;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001e\u001a\u00020\u0019J\b\u0010\u001f\u001a\u0004\u0018\u00010\u001bJ\r\u0010 \u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b!J7\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\b\u0010$\u001a\u0004\u0018\u00010\u00172\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H#0&H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0*\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u0019J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020\nJ\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0017J\u0006\u00105\u001a\u00020\u0017J\u0006\u00106\u001a\u00020\u0017J\b\u00107\u001a\u00020\nH\u0002J\u0006\u00108\u001a\u000203J\b\u00109\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lokhttp3/tls/internal/der/DerReader;", "", "source", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "countingSource", "Lokhttp3/tls/internal/der/DerReader$CountingSource;", "Lokio/BufferedSource;", "byteCount", "", "getByteCount", "()J", "limit", "typeHintStack", "", "value", "typeHint", "getTypeHint", "()Ljava/lang/Object;", "setTypeHint", "(Ljava/lang/Object;)V", "path", "", "constructed", "", "peekedHeader", "Lokhttp3/tls/internal/der/DerHeader;", "bytesLeft", "getBytesLeft", "hasNext", "peekHeader", "readHeader", "readHeader$okhttp_tls", "read", "T", "name", "block", "Lkotlin/Function1;", "read$okhttp_tls", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withTypeHint", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readBoolean", "readBigInteger", "Ljava/math/BigInteger;", "readLong", "readBitString", "Lokhttp3/tls/internal/der/BitString;", "readOctetString", "Lokio/ByteString;", "readUtf8String", "readObjectIdentifier", "readRelativeObjectIdentifier", "readVariableLengthLong", "readUnknown", "toString", "Companion", "CountingSource", "okhttp-tls"})
public final class DerReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CountingSource countingSource;
    @NotNull
    private final BufferedSource source;
    private long limit;
    @NotNull
    private final List<Object> typeHintStack;
    @NotNull
    private final List<String> path;
    private boolean constructed;
    @Nullable
    private DerHeader peekedHeader;
    @NotNull
    private static final DerHeader END_OF_DATA = new DerHeader(0, 0L, false, -1L);

    public DerReader(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.countingSource = new CountingSource(source);
        this.source = Okio.buffer((Source)((Source)this.countingSource));
        this.limit = -1L;
        this.typeHintStack = new ArrayList();
        this.path = new ArrayList();
    }

    private final long getByteCount() {
        return this.countingSource.getBytesRead() - this.source.getBuffer().size();
    }

    @Nullable
    public final Object getTypeHint() {
        return CollectionsKt.lastOrNull(this.typeHintStack);
    }

    public final void setTypeHint(@Nullable Object value) {
        this.typeHintStack.set(this.typeHintStack.size() - 1, value);
    }

    private final long getBytesLeft() {
        return this.limit == -1L ? -1L : this.limit - this.getByteCount();
    }

    public final boolean hasNext() {
        return this.peekHeader() != null;
    }

    @Nullable
    public final DerHeader peekHeader() {
        DerHeader result = this.peekedHeader;
        if (result == null) {
            this.peekedHeader = result = this.readHeader$okhttp_tls();
        }
        if (result.isEndOfData()) {
            return null;
        }
        return result;
    }

    @NotNull
    public final DerHeader readHeader$okhttp_tls() {
        long l;
        if (!(this.peekedHeader == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getByteCount() == this.limit) {
            return END_OF_DATA;
        }
        if (this.limit == -1L && this.source.exhausted()) {
            return END_OF_DATA;
        }
        int tagAndClass = this.source.readByte() & 0xFF;
        int tagClass = tagAndClass & 0xC0;
        boolean constructed = (tagAndClass & 0x20) == 32;
        int tag0 = tagAndClass & 0x1F;
        long tag = tag0 == 31 ? this.readVariableLengthLong() : (long)tag0;
        int length0 = this.source.readByte() & 0xFF;
        if (length0 == 128) {
            throw new ProtocolException("indefinite length not permitted for DER");
        }
        if ((length0 & 0x80) == 128) {
            int lengthBytes = length0 & 0x7F;
            if (lengthBytes > 8) {
                throw new ProtocolException("length encoded with more than 8 bytes is not supported");
            }
            long lengthBits = (long)this.source.readByte() & 0xFFL;
            if (lengthBits == 0L || lengthBytes == 1 && (lengthBits & 0x80L) == 0L) {
                throw new ProtocolException("invalid encoding for length");
            }
            for (int i = 1; i < lengthBytes; ++i) {
                lengthBits <<= 8;
                lengthBits += (long)(this.source.readByte() & 0xFF);
            }
            if (lengthBits < 0L) {
                throw new ProtocolException("length > Long.MAX_VALUE");
            }
            l = lengthBits;
        } else {
            l = length0 & 0x7F;
        }
        long length = l;
        return new DerHeader(tagClass, tag, constructed, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T read$okhttp_tls(@Nullable String name, @NotNull Function1<? super DerHeader, ? extends T> block) {
        long newLimit;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$read$okhttp_tls = false;
        if (!this.hasNext()) {
            throw new ProtocolException("expected a value");
        }
        DerHeader derHeader = this.peekedHeader;
        Intrinsics.checkNotNull((Object)derHeader);
        DerHeader header = derHeader;
        this.peekedHeader = null;
        long pushedLimit = this.limit;
        boolean pushedConstructed = this.constructed;
        long l = newLimit = header.getLength() != -1L ? this.getByteCount() + header.getLength() : -1L;
        if (pushedLimit != -1L && newLimit > pushedLimit) {
            throw new ProtocolException("enclosed object too large");
        }
        this.limit = newLimit;
        this.constructed = header.getConstructed();
        if (name != null) {
            ((Collection)this.path).add(name);
        }
        try {
            Object result = block.invoke((Object)header);
            if (newLimit != -1L && this.getByteCount() > newLimit) {
                throw new ProtocolException("unexpected byte count at " + this);
            }
            Object object = result;
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.peekedHeader = null;
            this.limit = pushedLimit;
            this.constructed = pushedConstructed;
            if (name != null) {
                this.path.remove(this.path.size() - 1);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeHint(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.typeHintStack.add(null);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.typeHintStack.remove(this.typeHintStack.size() - 1);
        }
    }

    public final boolean readBoolean() {
        if (this.getBytesLeft() != 1L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        return this.source.readByte() != 0;
    }

    @NotNull
    public final BigInteger readBigInteger() {
        if (this.getBytesLeft() == 0L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        byte[] byteArray = this.source.readByteArray(this.getBytesLeft());
        return new BigInteger(byteArray);
    }

    public final long readLong() {
        long l = this.getBytesLeft();
        if (!(1L <= l ? l < 9L : false)) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        long result = this.source.readByte();
        while (this.getByteCount() < this.limit) {
            result <<= 8;
            result += (long)(this.source.readByte() & 0xFF);
        }
        return result;
    }

    @NotNull
    public final BitString readBitString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed bit strings not supported for DER");
        }
        if (this.getBytesLeft() < 1L) {
            throw new ProtocolException("malformed bit string");
        }
        int unusedBitCount = this.source.readByte() & 0xFF;
        ByteString byteString = this.source.readByteString(this.getBytesLeft());
        return new BitString(byteString, unusedBitCount);
    }

    @NotNull
    public final ByteString readOctetString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed octet strings not supported for DER");
        }
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public final String readUtf8String() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed strings not supported for DER");
        }
        return this.source.readUtf8(this.getBytesLeft());
    }

    @NotNull
    public final String readObjectIdentifier() {
        Buffer buffer;
        Buffer result = new Buffer();
        int dot = 46;
        long xy = this.readVariableLengthLong();
        boolean bl = 0L <= xy ? xy < 40L : false;
        if (bl) {
            result.writeDecimalLong(0L);
            result.writeByte(dot);
            buffer = result.writeDecimalLong(xy);
        } else {
            boolean bl2 = 40L <= xy ? xy < 80L : false;
            if (bl2) {
                result.writeDecimalLong(1L);
                result.writeByte(dot);
                buffer = result.writeDecimalLong(xy - 40L);
            } else {
                result.writeDecimalLong(2L);
                result.writeByte(dot);
                buffer = result.writeDecimalLong(xy - 80L);
            }
        }
        while (this.getByteCount() < this.limit) {
            result.writeByte(dot);
            result.writeDecimalLong(this.readVariableLengthLong());
        }
        return result.readUtf8();
    }

    @NotNull
    public final String readRelativeObjectIdentifier() {
        Buffer result = new Buffer();
        int dot = 46;
        while (this.getByteCount() < this.limit) {
            if (result.size() > 0L) {
                result.writeByte(dot);
            }
            result.writeDecimalLong(this.readVariableLengthLong());
        }
        return result.readUtf8();
    }

    private final long readVariableLengthLong() {
        long byteN;
        long result = 0L;
        while (((byteN = (long)this.source.readByte() & 0xFFL) & 0x80L) == 128L) {
            result = result + (byteN & 0x7FL) << 7;
        }
        return result + byteN;
    }

    @NotNull
    public final ByteString readUnknown() {
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lokhttp3/tls/internal/der/DerReader$Companion;", "", "<init>", "()V", "END_OF_DATA", "Lokhttp3/tls/internal/der/DerHeader;", "okhttp-tls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lokhttp3/tls/internal/der/DerReader$CountingSource;", "Lokio/ForwardingSource;", "source", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "bytesRead", "", "getBytesRead", "()J", "setBytesRead", "(J)V", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp-tls"})
    private static final class CountingSource
    extends ForwardingSource {
        private long bytesRead;

        public CountingSource(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source);
        }

        public final long getBytesRead() {
            return this.bytesRead;
        }

        public final void setBytesRead(long l) {
            this.bytesRead = l;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long result = this.delegate().read(sink, byteCount);
            if (result == -1L) {
                return -1L;
            }
            this.bytesRead += result;
            return result;
        }
    }
}

