/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.brotli.internal;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.brotli.dec.BrotliInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"uncompress", "Lokhttp3/Response;", "response", "okhttp-brotli"})
public final class UncompressKt {
    @NotNull
    public static final Response uncompress(@NotNull Response response) {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody((Response)response)) {
            return response;
        }
        ResponseBody body = response.body();
        String string = Response.header$default((Response)response, (String)"Content-Encoding", null, (int)2, null);
        if (string == null) {
            return response;
        }
        String encoding = string;
        if (StringsKt.equals((String)encoding, (String)"br", (boolean)true)) {
            bufferedSource = Okio.buffer((Source)Okio.source((InputStream)((InputStream)new BrotliInputStream(body.source().inputStream()))));
        } else if (StringsKt.equals((String)encoding, (String)"gzip", (boolean)true)) {
            bufferedSource = Okio.buffer((Source)((Source)new GzipSource((Source)body.source())));
        } else {
            return response;
        }
        BufferedSource decompressedSource = bufferedSource;
        return response.newBuilder().removeHeader("Content-Encoding").removeHeader("Content-Length").body(ResponseBody.Companion.create(decompressedSource, body.contentType(), -1L)).build();
    }
}

