/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.mockwebserver.PushPromise;
import com.squareup.okhttp.mockwebserver.SocketPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MockResponse
implements Cloneable {
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";
    private String status = "HTTP/1.1 200 OK";
    private List<String> headers = new ArrayList<String>();
    private byte[] body;
    private InputStream bodyStream;
    private int throttleBytesPerPeriod = Integer.MAX_VALUE;
    private long throttlePeriod = 1L;
    private TimeUnit throttleUnit = TimeUnit.SECONDS;
    private SocketPolicy socketPolicy = SocketPolicy.KEEP_OPEN;
    private int bodyDelayTimeMs = 0;
    private List<PushPromise> promises = new ArrayList<PushPromise>();

    public MockResponse() {
        this.setBody(new byte[0]);
    }

    public MockResponse clone() {
        try {
            MockResponse result = (MockResponse)super.clone();
            result.headers = new ArrayList<String>(this.headers);
            result.promises = new ArrayList<PushPromise>(this.promises);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public MockResponse setResponseCode(int code) {
        this.status = "HTTP/1.1 " + code + " OK";
        return this;
    }

    public MockResponse setStatus(String status) {
        this.status = status;
        return this;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public MockResponse clearHeaders() {
        this.headers.clear();
        return this;
    }

    public MockResponse addHeader(String header) {
        this.headers.add(header);
        return this;
    }

    public MockResponse addHeader(String name, Object value) {
        return this.addHeader(name + ": " + String.valueOf(value));
    }

    public MockResponse setHeader(String name, Object value) {
        this.removeHeader(name);
        return this.addHeader(name, value);
    }

    public MockResponse removeHeader(String name) {
        name = name + ":";
        Iterator<String> i = this.headers.iterator();
        while (i.hasNext()) {
            String header = i.next();
            if (!name.regionMatches(true, 0, header, 0, name.length())) continue;
            i.remove();
        }
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    InputStream getBodyStream() {
        return this.bodyStream != null ? this.bodyStream : new ByteArrayInputStream(this.body);
    }

    public MockResponse setBody(byte[] body) {
        this.setHeader("Content-Length", body.length);
        this.body = body;
        this.bodyStream = null;
        return this;
    }

    public MockResponse setBody(InputStream bodyStream, long bodyLength) {
        this.setHeader("Content-Length", bodyLength);
        this.body = null;
        this.bodyStream = bodyStream;
        return this;
    }

    public MockResponse setBody(String body) {
        try {
            return this.setBody(body.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public MockResponse setChunkedBody(byte[] body, int maxChunkSize) {
        this.removeHeader("Content-Length");
        this.headers.add(CHUNKED_BODY_HEADER);
        try {
            int chunkSize;
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            for (int pos = 0; pos < body.length; pos += chunkSize) {
                chunkSize = Math.min(body.length - pos, maxChunkSize);
                bytesOut.write(Integer.toHexString(chunkSize).getBytes(Util.US_ASCII));
                bytesOut.write("\r\n".getBytes(Util.US_ASCII));
                bytesOut.write(body, pos, chunkSize);
                bytesOut.write("\r\n".getBytes(Util.US_ASCII));
            }
            bytesOut.write("0\r\n\r\n".getBytes(Util.US_ASCII));
            this.body = bytesOut.toByteArray();
            return this;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public MockResponse setChunkedBody(String body, int maxChunkSize) {
        try {
            return this.setChunkedBody(body.getBytes("UTF-8"), maxChunkSize);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public SocketPolicy getSocketPolicy() {
        return this.socketPolicy;
    }

    public MockResponse setSocketPolicy(SocketPolicy socketPolicy) {
        this.socketPolicy = socketPolicy;
        return this;
    }

    public MockResponse throttleBody(int bytesPerPeriod, long period, TimeUnit unit) {
        this.throttleBytesPerPeriod = bytesPerPeriod;
        this.throttlePeriod = period;
        this.throttleUnit = unit;
        return this;
    }

    public int getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    public long getThrottlePeriod() {
        return this.throttlePeriod;
    }

    public TimeUnit getThrottleUnit() {
        return this.throttleUnit;
    }

    public MockResponse setBodyDelayTimeMs(int delay) {
        this.bodyDelayTimeMs = delay;
        return this;
    }

    public int getBodyDelayTimeMs() {
        return this.bodyDelayTimeMs;
    }

    public MockResponse withPush(PushPromise promise) {
        this.promises.add(promise);
        return this;
    }

    public List<PushPromise> getPushPromises() {
        return this.promises;
    }

    public String toString() {
        return this.status;
    }
}

