/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class SslContextBuilder {
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static SSLContext localhost;
    private final String hostName;
    private long notBefore = System.currentTimeMillis();
    private long notAfter = System.currentTimeMillis() + 86400000L;

    public SslContextBuilder(String hostName) {
        this.hostName = hostName;
    }

    public static synchronized SSLContext localhost() {
        if (localhost == null) {
            try {
                localhost = new SslContextBuilder(InetAddress.getLocalHost().getHostName()).build();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localhost;
    }

    public SSLContext build() throws GeneralSecurityException {
        char[] password = "password".toCharArray();
        KeyPair keyPair = this.generateKeyPair();
        X509Certificate certificate = this.selfSignedCertificate(keyPair);
        KeyStore keyStore = this.newEmptyKeyStore(password);
        Certificate[] certificateChain = new Certificate[]{certificate};
        keyStore.setKeyEntry("private", keyPair.getPrivate(), password, certificateChain);
        keyStore.setCertificateEntry("cert", certificate);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private KeyPair generateKeyPair() throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    private X509Certificate selfSignedCertificate(KeyPair keyPair) throws GeneralSecurityException {
        X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
        X500Principal issuer = new X500Principal("CN=" + this.hostName);
        X500Principal subject = new X500Principal("CN=" + this.hostName);
        generator.setSerialNumber(BigInteger.ONE);
        generator.setIssuerDN(issuer);
        generator.setNotBefore(new Date(this.notBefore));
        generator.setNotAfter(new Date(this.notAfter));
        generator.setSubjectDN(subject);
        generator.setPublicKey(keyPair.getPublic());
        generator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        return generator.generateX509Certificate(keyPair.getPrivate(), "BC");
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

