/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.google.auto.common;

import com.google.common.base.Preconditions;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import shadow.com.google.auto.common.MoreTypes;

public final class SimpleTypeAnnotationValue
implements AnnotationValue {
    private final TypeMirror value;

    private SimpleTypeAnnotationValue(TypeMirror value2) {
        Preconditions.checkArgument((value2.getKind().isPrimitive() || value2.getKind().equals((Object)TypeKind.DECLARED) || value2.getKind().equals((Object)TypeKind.ARRAY) ? 1 : 0) != 0, (String)"value must be a primitive, array, or declared type, but was %s (%s)", (Object)((Object)value2.getKind()), (Object)value2);
        if (value2.getKind().equals((Object)TypeKind.DECLARED)) {
            Preconditions.checkArgument((boolean)MoreTypes.asDeclared(value2).getTypeArguments().isEmpty(), (String)"value must not be a parameterized type: %s", (Object)value2);
        }
        this.value = value2;
    }

    public static AnnotationValue of(TypeMirror value2) {
        return new SimpleTypeAnnotationValue(value2);
    }

    @Override
    public TypeMirror getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value + ".class";
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> visitor, P parameter) {
        return visitor.visitType(this.getValue(), parameter);
    }
}

