/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import shark.AndroidBuildMirror;
import shark.AndroidMetadataExtractor;
import shark.GcRoot;
import shark.HeapGraph;
import shark.HeapObject;
import shark.MetadataExtractor;
import shark.internal.AndroidNativeSizeMapper;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lshark/AndroidMetadataExtractor;", "Lshark/MetadataExtractor;", "()V", "extractMetadata", "", "", "graph", "Lshark/HeapGraph;", "readHeapTotalBytes", "", "readLeakCanaryVersion", "readProcessName", "readThreadCount", "putBitmaps", "", "", "putDbLabels", "shark-android"})
public final class AndroidMetadataExtractor
implements MetadataExtractor {
    @NotNull
    public static final AndroidMetadataExtractor INSTANCE;

    @NotNull
    public Map<String, String> extractMetadata(@NotNull HeapGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        boolean bl = false;
        Map metadata = new LinkedHashMap();
        AndroidBuildMirror build = AndroidBuildMirror.Companion.fromHeapGraph(graph);
        metadata.put("Build.VERSION.SDK_INT", String.valueOf(build.getSdkInt()));
        metadata.put("Build.MANUFACTURER", build.getManufacturer());
        metadata.put("LeakCanary version", this.readLeakCanaryVersion(graph));
        metadata.put("App process name", this.readProcessName(graph));
        metadata.put("Class count", String.valueOf(graph.getClassCount()));
        metadata.put("Instance count", String.valueOf(graph.getInstanceCount()));
        metadata.put("Primitive array count", String.valueOf(graph.getPrimitiveArrayCount()));
        metadata.put("Object array count", String.valueOf(graph.getObjectArrayCount()));
        metadata.put("Thread count", String.valueOf(this.readThreadCount(graph)));
        metadata.put("Heap total bytes", String.valueOf(this.readHeapTotalBytes(graph)));
        this.putBitmaps(metadata, graph);
        this.putDbLabels(metadata, graph);
        return metadata;
    }

    /*
     * WARNING - void declaration
     */
    private final int readHeapTotalBytes(HeapGraph graph) {
        Sequence $this$sumBy$iv = graph.getObjects();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            int n;
            void heapObject;
            HeapObject heapObject2 = (HeapObject)element$iv;
            int n2 = sum$iv;
            boolean bl = false;
            void var9_9 = heapObject;
            if (var9_9 instanceof HeapObject.HeapInstance) {
                n = ((HeapObject.HeapInstance)heapObject).getByteSize();
            } else if (var9_9 instanceof HeapObject.HeapClass) {
                n = heapObject.getRecordSize();
            } else if (var9_9 instanceof HeapObject.HeapObjectArray) {
                n = ((HeapObject.HeapObjectArray)heapObject).getByteSize();
            } else if (var9_9 instanceof HeapObject.HeapPrimitiveArray) {
                n = ((HeapObject.HeapPrimitiveArray)heapObject).getByteSize();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int n3 = n;
            sum$iv = n2 + n3;
        }
        return sum$iv;
    }

    private final void putBitmaps(Map<String, String> $this$putBitmaps, HeapGraph graph) {
        HeapObject.HeapClass heapClass = graph.findClassByName("android.graphics.Bitmap");
        if (heapClass == null) {
            return;
        }
        HeapObject.HeapClass bitmapClass = heapClass;
        Object object = graph.findClassByName("android.util.DisplayMetrics");
        int maxDisplayPixels2 = object != null && (object = object.getDirectInstances()) != null && (object = SequencesKt.map((Sequence)object, (Function1)putBitmaps.maxDisplayPixels.1.INSTANCE)) != null && (object = (Integer)SequencesKt.max((Sequence)object)) != null ? (Integer)object : 0;
        int maxDisplayPixelsWithThreshold = (int)((double)maxDisplayPixels2 * 1.1);
        HeapGraph $this$mapNativeSizes$iv = graph;
        boolean $i$f$mapNativeSizes = false;
        Map sizeMap = AndroidNativeSizeMapper.Companion.mapNativeSizes($this$mapNativeSizes$iv);
        int sizeSum = 0;
        int count = 0;
        int largeBitmapCount = 0;
        int largeBitmapSizeSum = 0;
        Sequence $this$forEach$iv = bitmapClass.getInstances();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapInstance bitmap = (HeapObject.HeapInstance)element$iv;
            boolean bl = false;
            Object object2 = bitmap.get("android.graphics.Bitmap", "mWidth");
            int width = object2 != null && (object2 = object2.getValue()) != null && (object2 = object2.getAsInt()) != null ? (Integer)object2 : 0;
            Object object3 = bitmap.get("android.graphics.Bitmap", "mHeight");
            int height = object3 != null && (object3 = object3.getValue()) != null && (object3 = object3.getAsInt()) != null ? (Integer)object3 : 0;
            Integer n = (Integer)sizeMap.get(bitmap.getObjectId());
            int size = n != null ? n : 0;
            int n2 = count;
            count = n2 + 1;
            sizeSum += size;
            if (maxDisplayPixelsWithThreshold <= 0 || width * height <= maxDisplayPixelsWithThreshold) continue;
            n2 = largeBitmapCount;
            largeBitmapCount = n2 + 1;
            largeBitmapSizeSum += size;
        }
        $this$putBitmaps.put("Bitmap count", String.valueOf(count));
        $this$putBitmaps.put("Bitmap total bytes", String.valueOf(sizeSum));
        $this$putBitmaps.put("Large bitmap count", String.valueOf(largeBitmapCount));
        $this$putBitmaps.put("Large bitmap total bytes", String.valueOf(largeBitmapSizeSum));
    }

    /*
     * WARNING - void declaration
     */
    private final int readThreadCount(HeapGraph graph) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = graph.getGcRoots();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GcRoot.ThreadObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GcRoot.ThreadObject threadObject = (GcRoot.ThreadObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getId();
            collection.add(l);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size();
    }

    private final String readLeakCanaryVersion(HeapGraph graph) {
        HeapObject.HeapClass versionHolderClass = graph.findClassByName("leakcanary.internal.InternalLeakCanary");
        Object object = versionHolderClass;
        if (object == null || (object = object.get("version")) == null || (object = object.getValue()) == null || (object = object.readAsJavaString()) == null) {
            object = "Unknown";
        }
        return object;
    }

    private final String readProcessName(HeapGraph graph) {
        HeapObject.HeapClass heapClass = graph.findClassByName("android.app.ActivityThread");
        HeapObject.HeapInstance activityThread = heapClass != null && (heapClass = heapClass.get("sCurrentActivityThread")) != null ? heapClass.getValueAsInstance() : null;
        HeapObject.HeapInstance heapInstance = activityThread;
        HeapObject.HeapInstance appBindData = heapInstance != null && (heapInstance = heapInstance.get("android.app.ActivityThread", "mBoundApplication")) != null ? heapInstance.getValueAsInstance() : null;
        HeapObject.HeapInstance heapInstance2 = appBindData;
        HeapObject.HeapInstance appInfo = heapInstance2 != null && (heapInstance2 = heapInstance2.get("android.app.ActivityThread$AppBindData", "appInfo")) != null ? heapInstance2.getValueAsInstance() : null;
        Object object = appInfo;
        if (object == null || (object = object.get("android.content.pm.ApplicationInfo", "processName")) == null || (object = object.getValueAsInstance()) == null || (object = object.readAsJavaString()) == null) {
            object = "Unknown";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void putDbLabels(Map<String, String> $this$putDbLabels, HeapGraph graph) {
        Sequence openDbLabels2;
        HeapObject.HeapClass heapClass = graph.findClassByName("android.database.sqlite.SQLiteDatabase");
        if (heapClass == null) {
            return;
        }
        HeapObject.HeapClass dbClass = heapClass;
        Sequence $this$forEachIndexed$iv = openDbLabels2 = SequencesKt.mapNotNull((Sequence)dbClass.getInstances(), (Function1)putDbLabels.openDbLabels.1.INSTANCE);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void label;
            void $dstr$label$open;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Pair pair = (Pair)item$iv;
            int index = n2;
            boolean bl2 = false;
            String string = (String)$dstr$label$open.component1();
            boolean open = (Boolean)$dstr$label$open.component2();
            $this$putDbLabels.put("Db " + (index + 1), (open ? "open " : "closed ") + (String)label);
        }
    }

    private AndroidMetadataExtractor() {
    }

    static {
        AndroidMetadataExtractor androidMetadataExtractor;
        INSTANCE = androidMetadataExtractor = new AndroidMetadataExtractor();
    }
}

