/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u000f\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u001a\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0000\u001a/\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a/\u0010\u0017\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a/\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u001a\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u0006H\u0000\u001a1\u0010\u001d\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001e0\u0015\"\u0002H\u001eH\u0000\u00a2\u0006\u0002\u0010!\u001a\f\u0010\"\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\f\u0010#\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\f\u0010$\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\f\u0010%\u001a\u00020\u0004*\u00020\u0004H\u0000\u001aW\u0010&\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u001e*\u0002H\u001e2\u0006\u0010'\u001a\u0002H\u001e2\u0006\u0010(\u001a\u0002H\u001e2\n\b\u0002\u0010)\u001a\u0004\u0018\u0001H\u001e2\n\b\u0002\u0010*\u001a\u0004\u0018\u0001H\u001e2\n\b\u0002\u0010+\u001a\u0004\u0018\u0001H\u001e2\n\b\u0002\u0010,\u001a\u0004\u0018\u0001H\u001eH\u0000\u00a2\u0006\u0002\u0010-\u001a+\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0003\"\u0010\b\u0000\u0010\u001e\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u001e0/*\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0080\b\u001a\u001e\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001e01\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0000\u001a0\u00102\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H503\"\u0004\b\u0000\u00104\"\u0004\b\u0001\u00105*\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H503H\u0000\u001a\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0003\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0\u001fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0006*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0018\u0010\u000b\u001a\u00020\u0006*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\"\u0018\u0010\f\u001a\u00020\u0006*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007\u00a8\u00067"}, d2={"IDENTIFIER_REGEX", "Lkotlin/text/Regex;", "KEYWORDS", "", "", "isIdentifier", "", "(Ljava/lang/String;)Z", "isIsoControl", "", "(C)Z", "isKeyword", "isName", "characterLiteralWithoutSingleQuotes", "kotlin.jvm.PlatformType", "c", "requireExactlyOneOf", "", "modifiers", "Lcom/squareup/kotlinpoet/KModifier;", "mutuallyExclusive", "", "(Ljava/util/Set;[Lcom/squareup/kotlinpoet/KModifier;)V", "requireNoneOf", "forbidden", "requireNoneOrOneOf", "stringLiteralWithQuotes", "value", "escapeDollarSign", "containsAnyOf", "T", "", "t", "(Ljava/util/Collection;[Ljava/lang/Object;)Z", "escapeIfKeyword", "escapeIfNecessary", "escapeIfNotJavaIdentifier", "escapeKeywords", "isOneOf", "t1", "t2", "t3", "t4", "t5", "t6", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "toEnumSet", "", "toImmutableList", "", "toImmutableMap", "", "K", "V", "toImmutableSet", "kotlinpoet"})
public final class UtilKt {
    private static final Regex IDENTIFIER_REGEX;
    private static final Set<String> KEYWORDS;

    @NotNull
    public static final <K, V> Map<K, V> toImmutableMap(@NotNull Map<K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Map map = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.unmodifiableMap(LinkedHashMap(this))");
        return map;
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@NotNull Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        List list = Collections.unmodifiableList((List)new ArrayList<T>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(ArrayList(this))");
        return list;
    }

    @NotNull
    public static final <T> Set<T> toImmutableSet(@NotNull Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Set set = Collections.unmodifiableSet((Set)new LinkedHashSet<T>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(LinkedHashSet(this))");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends Enum<T>> Set<T> toEnumSet(@NotNull Collection<? extends T> $receiver) {
        void $receiver$iv;
        Intrinsics.reifiedOperationMarker((int)5, (String)"T");
        Enum[] enumArray = new Enum[]{};
        Collection collection = new LinkedHashSet();
        Collection<T> collection2 = $receiver;
        for (void element$iv : $receiver$iv) {
            void destination$iv;
            void p1 = element$iv;
            if (!collection2.contains(p1)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)collection;
    }

    /*
     * WARNING - void declaration
     */
    public static final void requireExactlyOneOf(@NotNull Set<? extends KModifier> modifiers, KModifier ... mutuallyExclusive) {
        boolean bl;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)mutuallyExclusive, (String)"mutuallyExclusive");
        KModifier[] kModifierArray = mutuallyExclusive;
        KModifier[] kModifierArray2 = modifiers;
        int count$iv = 0;
        for (void element$iv : $receiver$iv) {
            void p1 = element$iv;
            if (!kModifierArray2.contains(p1)) continue;
            ++count$iv;
        }
        int count = count$iv;
        boolean bl2 = bl = count == 1;
        if (!bl) {
            kModifierArray2 = mutuallyExclusive;
            CharSequence charSequence = new StringBuilder().append("modifiers ").append(modifiers).append(" must contain one of ");
            String string = Arrays.toString((Object[])kModifierArray2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.util.Arrays.toString(this)");
            String string2 = string;
            charSequence = ((StringBuilder)charSequence).append(string2).toString();
            throw (Throwable)new IllegalArgumentException(((Object)charSequence).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void requireNoneOrOneOf(@NotNull Set<? extends KModifier> modifiers, KModifier ... mutuallyExclusive) {
        boolean bl;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)mutuallyExclusive, (String)"mutuallyExclusive");
        KModifier[] kModifierArray = mutuallyExclusive;
        KModifier[] kModifierArray2 = modifiers;
        int count$iv = 0;
        for (void element$iv : $receiver$iv) {
            void p1 = element$iv;
            if (!kModifierArray2.contains(p1)) continue;
            ++count$iv;
        }
        int count = count$iv;
        boolean bl2 = bl = count <= 1;
        if (!bl) {
            kModifierArray2 = mutuallyExclusive;
            CharSequence charSequence = new StringBuilder().append("modifiers ").append(modifiers).append(" must contain none or only one of ");
            String string = Arrays.toString((Object[])kModifierArray2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.util.Arrays.toString(this)");
            String string2 = string;
            charSequence = ((StringBuilder)charSequence).append(string2).toString();
            throw (Throwable)new IllegalArgumentException(((Object)charSequence).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void requireNoneOf(@NotNull Set<? extends KModifier> modifiers, KModifier ... forbidden) {
        boolean bl;
        KModifier[] kModifierArray;
        block2: {
            boolean bl2;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
            Intrinsics.checkParameterIsNotNull((Object)forbidden, (String)"forbidden");
            KModifier[] kModifierArray2 = forbidden;
            kModifierArray = modifiers;
            for (void element$iv : $receiver$iv) {
                void p1 = element$iv;
                if (!kModifierArray.contains(p1)) continue;
                bl2 = false;
                break block2;
            }
            bl2 = bl = true;
        }
        if (!bl) {
            kModifierArray = forbidden;
            CharSequence charSequence = new StringBuilder().append("modifiers ").append(modifiers).append(" must contain none of ");
            String string = Arrays.toString((Object[])kModifierArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.util.Arrays.toString(this)");
            String string2 = string;
            charSequence = ((StringBuilder)charSequence).append(string2).toString();
            throw (Throwable)new IllegalArgumentException(((Object)charSequence).toString());
        }
    }

    public static final <T> boolean isOneOf(T $receiver, T t1, T t2, @Nullable T t3, @Nullable T t4, @Nullable T t5, @Nullable T t6) {
        return Intrinsics.areEqual($receiver, t1) || Intrinsics.areEqual($receiver, t2) || Intrinsics.areEqual($receiver, t3) || Intrinsics.areEqual($receiver, t4) || Intrinsics.areEqual($receiver, t5) || Intrinsics.areEqual($receiver, t6);
    }

    public static /* synthetic */ boolean isOneOf$default(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, int n, Object object8) {
        if ((n & 4) != 0) {
            object4 = null;
        }
        if ((n & 8) != 0) {
            object5 = null;
        }
        if ((n & 0x10) != 0) {
            object6 = null;
        }
        if ((n & 0x20) != 0) {
            object7 = null;
        }
        return UtilKt.isOneOf(object, object2, object3, object4, object5, object6, object7);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> boolean containsAnyOf(@NotNull Collection<? extends T> $receiver, T ... t) {
        boolean bl;
        block1: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull(t, (String)"t");
            T[] TArray = t;
            Collection<T> collection = $receiver;
            for (void element$iv : $receiver$iv) {
                void p1 = element$iv;
                if (!collection.contains(p1)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final String characterLiteralWithoutSingleQuotes(char c) {
        String string;
        if (c == '\b') {
            string = "\\b";
        } else if (c == '\t') {
            string = "\\t";
        } else if (c == '\n') {
            string = "\\n";
        } else if (c == '\r') {
            string = "\\r";
        } else if (c == '\"') {
            string = "\"";
        } else if (c == '\'') {
            string = "\\'";
        } else if (c == '\\') {
            string = "\\\\";
        } else if (UtilKt.isIsoControl(c)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "\\u%04x";
            Object[] objectArray = new Object[]{(int)c};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            string = Character.toString(c);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIsoControl(char $receiver) {
        char c = $receiver;
        if ('\u0000' <= c) {
            if ('\u001f' >= c) return true;
        }
        c = $receiver;
        if ('\u007f' > c) return false;
        if ('\u009f' < c) return false;
        return true;
    }

    @NotNull
    public static final String stringLiteralWithQuotes(@NotNull String value, boolean escapeDollarSign) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (StringsKt.contains$default((CharSequence)value, (char)'\n', (boolean)false, (int)2, null)) {
            StringBuilder result = new StringBuilder(value.length() + 32);
            result.append("\"\"\"\n|");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (StringsKt.regionMatches$default((String)value, (int)i, (String)"\"\"\"", (int)0, (int)3, (boolean)false, (int)16, null)) {
                    result.append("\"\"${'\"'}");
                    i += 2;
                    continue;
                }
                if (c == '\n') {
                    result.append("\n|");
                    continue;
                }
                if (c == '$' && escapeDollarSign) {
                    result.append("${'$'}");
                    continue;
                }
                result.append(c);
            }
            if (!StringsKt.endsWith$default((String)value, (String)"\n", (boolean)false, (int)2, null)) {
                result.append("\n");
            }
            result.append("\"\"\".trimMargin()");
            String string = result.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }
        StringBuilder result = new StringBuilder(value.length() + 32);
        result.append('\"');
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                result.append("'");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            if (c == '$' && escapeDollarSign) {
                result.append("${'$'}");
                continue;
            }
            result.append(UtilKt.characterLiteralWithoutSingleQuotes(c));
        }
        result.append('\"');
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public static /* synthetic */ String stringLiteralWithQuotes$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilKt.stringLiteralWithQuotes(string, bl);
    }

    @NotNull
    public static final String escapeKeywords(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$receiver, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)escapeKeywords.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String escapeIfKeyword(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return UtilKt.isKeyword($receiver) ? '`' + $receiver + '`' : $receiver;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String escapeIfNotJavaIdentifier(@NotNull String $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (Character.isJavaIdentifierStart(StringsKt.first((CharSequence)$receiver))) {
            boolean bl;
            block3: {
                CharSequence $receiver$iv;
                CharSequence charSequence = $receiver$iv = (CharSequence)StringsKt.drop((String)$receiver, (int)1);
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv = charSequence.charAt(i);
                    char it = element$iv;
                    if (!(!Character.isJavaIdentifierPart(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) {
                string = $receiver;
                return string;
            }
        }
        string = '`' + $receiver + '`';
        return string;
    }

    @NotNull
    public static final String escapeIfNecessary(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return UtilKt.escapeIfKeyword(UtilKt.escapeIfNotJavaIdentifier($receiver));
    }

    public static final boolean isIdentifier(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IDENTIFIER_REGEX.matches((CharSequence)$receiver);
    }

    public static final boolean isKeyword(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return KEYWORDS.contains($receiver);
    }

    public static final boolean isName(@NotNull String $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Iterable $receiver$iv = StringsKt.split$default((CharSequence)$receiver, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!UtilKt.isKeyword(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        String string = "((\\p{gc=Lu}+|\\p{gc=Ll}+|\\p{gc=Lt}+|\\p{gc=Lm}+|\\p{gc=Lo}+|\\p{gc=Nl}+)+\\d*\\p{gc=Lu}*\\p{gc=Ll}*\\p{gc=Lt}*\\p{gc=Lm}*\\p{gc=Lo}*\\p{gc=Nl}*)|(`[^\n\r`]+`)";
        IDENTIFIER_REGEX = new Regex(string);
        KEYWORDS = SetsKt.setOf((Object[])new String[]{"package", "as", "typealias", "class", "this", "super", "val", "var", "fun", "for", "null", "true", "false", "is", "in", "throw", "return", "break", "continue", "object", "if", "try", "else", "while", "do", "when", "interface", "typeof"});
    }
}

