/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import com.squareup.kotlinpoet.KModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Util {
    private Util() {
    }

    static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> multimap) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<K, List<V>> entry : multimap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), Util.immutableList((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    static <T> List<T> immutableList(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    static <T> Set<T> immutableSet(Collection<T> set) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    static void requireExactlyOneOf(Set<KModifier> modifiers, KModifier ... mutuallyExclusive) {
        int count = 0;
        for (KModifier modifier : mutuallyExclusive) {
            if (!modifiers.contains((Object)modifier)) continue;
            ++count;
        }
        if (count != 1) {
            throw new IllegalArgumentException(String.format("modifiers %s must contain one of %s", modifiers, Arrays.toString((Object[])mutuallyExclusive)));
        }
    }

    static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    static String stringLiteralWithQuotes(String value, String indent) {
        if (value.contains("\n")) {
            StringBuilder result = new StringBuilder(value.length() + 32);
            result.append("\"\"\"\n|");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (value.regionMatches(i, "\"\"\"", 0, 3)) {
                    result.append("\"\"${'\"'}");
                    i += 2;
                    continue;
                }
                if (c == '\n') {
                    result.append("\n|");
                    continue;
                }
                result.append(c);
            }
            if (!value.endsWith("\n")) {
                result.append("\n");
            }
            result.append("\"\"\".trimMargin()");
            return result.toString();
        }
        StringBuilder result = new StringBuilder(value.length() + 32);
        result.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                result.append("'");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(Util.characterLiteralWithoutSingleQuotes(c));
        }
        result.append('\"');
        return result.toString();
    }
}

