/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.internal;

import android.util.SparseArray;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.util.Strings;

public final class IntegerUtils {
    public static BitMaskStringBuilder buildBitMaskString(int value) {
        return new BitMaskStringBuilder(value);
    }

    public static NamedValueStringBuilder buildNamedValueString(int value) {
        return new NamedValueStringBuilder(value);
    }

    private IntegerUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    public static final class NamedValueStringBuilder {
        private final int value;
        private final SparseArray<String> valueNames = new SparseArray();

        private NamedValueStringBuilder(int value) {
            this.value = value;
        }

        public NamedValueStringBuilder value(int value, String name) {
            String dupe = (String)this.valueNames.get(value);
            if (dupe != null) {
                throw new IllegalStateException("Duplicate value " + value + " with name " + dupe + " and " + name);
            }
            this.valueNames.put(value, (Object)name);
            return this;
        }

        public String getOrValue() {
            return (String)this.valueNames.get(this.value, (Object)String.valueOf(this.value));
        }

        public String get() {
            String name = (String)this.valueNames.get(this.value);
            if (name == null) {
                throw new IllegalStateException("Unknown value: " + this.value);
            }
            return name;
        }
    }

    public static final class BitMaskStringBuilder {
        private final int value;
        private final Map<Integer, String> parts = new LinkedHashMap<Integer, String>();

        private BitMaskStringBuilder(int value) {
            this.value = value;
        }

        public BitMaskStringBuilder flag(int flag, String flagName) {
            if ((this.value & flag) != 0) {
                if (this.parts.containsKey(flag)) {
                    this.parts.put(flag, this.parts.get(flag) + "|" + flagName);
                } else {
                    this.parts.put(flag, flagName);
                }
            }
            return this;
        }

        public String get() {
            if (this.value == 0) {
                return "none";
            }
            return Strings.join(this.parts.values()).with(", ");
        }
    }
}

