/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.VideoView;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class VideoViewAssert
extends AbstractViewAssert<VideoViewAssert, VideoView> {
    public VideoViewAssert(VideoView actual) {
        super(actual, VideoViewAssert.class);
    }

    public VideoViewAssert isPausable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canPause()).overridingErrorMessage("Expected to be pausable but was not.", new Object[0])).isTrue();
        return this;
    }

    public VideoViewAssert isNotPausable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canPause()).overridingErrorMessage("Expected to not be pausable but was.", new Object[0])).isFalse();
        return this;
    }

    public VideoViewAssert isSeekableBackward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canSeekBackward()).overridingErrorMessage("Expected to be seekable backward but was not.", new Object[0])).isTrue();
        return this;
    }

    public VideoViewAssert isNotSeekableBackward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canSeekBackward()).overridingErrorMessage("Expected to not be seekable backward but was.", new Object[0])).isFalse();
        return this;
    }

    public VideoViewAssert isSeekableForward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canSeekForward()).overridingErrorMessage("Expected to be seekable forward but was not.", new Object[0])).isTrue();
        return this;
    }

    public VideoViewAssert isNotSeekableForward() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).canSeekForward()).overridingErrorMessage("Expected to not be seekable forward but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=18)
    public VideoViewAssert hasAudioSessionId(int id) {
        this.isNotNull();
        int actualId = ((VideoView)this.actual).getAudioSessionId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected audio session ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public VideoViewAssert hasBufferPercentage(int percentage) {
        this.isNotNull();
        int actualPercentage = ((VideoView)this.actual).getBufferPercentage();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPercentage).overridingErrorMessage("Expected buffer percentage <%s> but was <%s>.", new Object[]{percentage, actualPercentage})).isEqualTo(percentage);
        return this;
    }

    public VideoViewAssert hasCurrentPosition(int position) {
        this.isNotNull();
        int actualPosition = ((VideoView)this.actual).getCurrentPosition();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected current position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    public VideoViewAssert hasDuration(int duration) {
        this.isNotNull();
        int actualDuration = ((VideoView)this.actual).getDuration();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return this;
    }

    public VideoViewAssert isPlaying() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).isPlaying()).overridingErrorMessage("Expected to be playing but was not.", new Object[0])).isTrue();
        return this;
    }

    public VideoViewAssert isNotPlaying() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((VideoView)this.actual).isPlaying()).overridingErrorMessage("Expected to not be playing but was.", new Object[0])).isFalse();
        return this;
    }
}

