/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.view.View;
import android.widget.Toast;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class ToastAssert
extends AbstractAssert<ToastAssert, Toast> {
    public ToastAssert(Toast actual) {
        super((Object)actual, ToastAssert.class);
    }

    public ToastAssert hasDuration(int duration) {
        this.isNotNull();
        int actualDuration = ((Toast)this.actual).getDuration();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return this;
    }

    public ToastAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((Toast)this.actual).getGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(actualGravity);
        return this;
    }

    public ToastAssert hasHorizontalMargin(float margin) {
        this.isNotNull();
        float actualMargin = ((Toast)this.actual).getHorizontalMargin();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualMargin).overridingErrorMessage("Expected horizontal margin <%s> but was <%s>.", new Object[]{Float.valueOf(margin), Float.valueOf(actualMargin)})).isEqualTo(margin);
        return this;
    }

    public ToastAssert hasVerticalMargin(float margin) {
        this.isNotNull();
        float actualMargin = ((Toast)this.actual).getVerticalMargin();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualMargin).overridingErrorMessage("Expected vertical margin <%s> but was <%s>.", new Object[]{Float.valueOf(margin), Float.valueOf(actualMargin)})).isEqualTo(margin);
        return this;
    }

    public ToastAssert hasView(View view) {
        this.isNotNull();
        View actualView = ((Toast)this.actual).getView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public ToastAssert hasXOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Toast)this.actual).getXOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected X offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public ToastAssert hasYOffset(int offset) {
        this.isNotNull();
        int actualOffset = ((Toast)this.actual).getYOffset();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOffset).overridingErrorMessage("Expected Y offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }
}

