/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.widget.TimePicker;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class TimePickerAssert
extends AbstractFrameLayoutAssert<TimePickerAssert, TimePicker> {
    public TimePickerAssert(TimePicker actual) {
        super(actual, TimePickerAssert.class);
    }

    public TimePickerAssert hasCurrentHour(Integer hour) {
        this.isNotNull();
        Integer actualHour = ((TimePicker)this.actual).getCurrentHour();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actualHour).overridingErrorMessage("Expected current hour <%s> but was <%s>.", new Object[]{hour, actualHour})).isEqualTo((Object)hour);
        return this;
    }

    public TimePickerAssert hasCurrentMinute(Integer minute) {
        this.isNotNull();
        Integer actualMinute = ((TimePicker)this.actual).getCurrentMinute();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)actualMinute).overridingErrorMessage("Expected current minute <%s> but was <%s>.", new Object[]{minute, actualMinute})).isEqualTo((Object)minute);
        return this;
    }

    public TimePickerAssert isIn24HourView() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TimePicker)this.actual).is24HourView()).overridingErrorMessage("Expected to be in 24 hour view but was not.", new Object[0])).isTrue();
        return this;
    }

    public TimePickerAssert isNotIn24HourView() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TimePicker)this.actual).is24HourView()).overridingErrorMessage("Expected to not be in 24 hour view but was.", new Object[0])).isFalse();
        return this;
    }
}

