/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.TabWidget;
import org.assertj.android.api.widget.AbstractLinearLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class TabWidgetAssert
extends AbstractLinearLayoutAssert<TabWidgetAssert, TabWidget> {
    public TabWidgetAssert(TabWidget actual) {
        super(actual, TabWidgetAssert.class);
    }

    public TabWidgetAssert hasTabCount(int count) {
        this.isNotNull();
        int actualCount = ((TabWidget)this.actual).getTabCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected tab count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=8)
    public TabWidgetAssert isStripEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TabWidget)this.actual).isStripEnabled()).overridingErrorMessage("Expected strip to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=8)
    public TabWidgetAssert isStripDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((TabWidget)this.actual).isStripEnabled()).overridingErrorMessage("Expected strip to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

