/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.widget.ScrollView;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class ScrollViewAssert
extends AbstractFrameLayoutAssert<ScrollViewAssert, ScrollView> {
    public ScrollViewAssert(ScrollView actual) {
        super(actual, ScrollViewAssert.class);
    }

    public ScrollViewAssert hasMaxScrollAmount(int amount) {
        this.isNotNull();
        int actualAmount = ((ScrollView)this.actual).getMaxScrollAmount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAmount).overridingErrorMessage("Expected maximum scroll amount <%s> but was <%s>.", new Object[]{amount, actualAmount})).isEqualTo(amount);
        return this;
    }

    public ScrollViewAssert isFillingViewport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to be filling viewport but was not.", new Object[0])).isTrue();
        return this;
    }

    public ScrollViewAssert isNotFillingViewport() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to not be filling viewport but was.", new Object[0])).isFalse();
        return this;
    }

    public ScrollViewAssert hasSmoothScrollEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scroll to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public ScrollViewAssert hasSmoothScrollDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scroll to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

