/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.GridView;
import org.assertj.android.api.widget.AbstractAbsListViewAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class GridViewAssert
extends AbstractAbsListViewAssert<GridViewAssert, GridView> {
    public GridViewAssert(GridView actual) {
        super(actual, GridViewAssert.class);
    }

    @TargetApi(value=16)
    public GridViewAssert hasColumnWidth(int width) {
        this.isNotNull();
        int actualWidth = ((GridView)this.actual).getColumnWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected column width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=16)
    public GridViewAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((GridView)this.actual).getGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    @TargetApi(value=16)
    public GridViewAssert hasHorizontalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getHorizontalSpacing();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected horizontal spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    @TargetApi(value=11)
    public GridViewAssert hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((GridView)this.actual).getNumColumns();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=16)
    public GridViewAssert hasRequestedColumnWidth(int width) {
        this.isNotNull();
        int actualWidth = ((GridView)this.actual).getRequestedColumnWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected requested column width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=16)
    public GridViewAssert hasRequestedHorizontalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getRequestedHorizontalSpacing();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected requested horizontal spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    public GridViewAssert hasStretchMode(int mode) {
        this.isNotNull();
        int actualMode = ((GridView)this.actual).getStretchMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected stretch mode <%s> but was <%s>.", new Object[]{GridViewAssert.stretchModeToString(mode), GridViewAssert.stretchModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    @TargetApi(value=16)
    public GridViewAssert hasVerticalSpacing(int spacing) {
        this.isNotNull();
        int actualSpacing = ((GridView)this.actual).getVerticalSpacing();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSpacing).overridingErrorMessage("Expected vertical spacing <%s> but was <%s>.", new Object[]{spacing, actualSpacing})).isEqualTo(spacing);
        return this;
    }

    public static String stretchModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(0, "noStretch").value(1, "stretchSpacing").value(3, "stretchSpacingUniform").value(2, "stretchColumnWidth").get();
    }
}

