/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.GridLayout;
import org.assertj.android.api.view.AbstractViewGroupAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=14)
public class GridLayoutAssert
extends AbstractViewGroupAssert<GridLayoutAssert, GridLayout> {
    public GridLayoutAssert(GridLayout actual) {
        super(actual, GridLayoutAssert.class);
    }

    public GridLayoutAssert hasAlignmentMode(int mode) {
        this.isNotNull();
        int actualMode = ((GridLayout)this.actual).getAlignmentMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected alignment mode <%s> but was <%s>.", new Object[]{GridLayoutAssert.alignmentModeToString(mode), GridLayoutAssert.alignmentModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public GridLayoutAssert hasColumnCount(int count) {
        this.isNotNull();
        int actualCount = ((GridLayout)this.actual).getColumnCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected column count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public GridLayoutAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((GridLayout)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{GridLayoutAssert.orientationToString(orientation), GridLayoutAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return this;
    }

    public GridLayoutAssert isVertical() {
        return this.hasOrientation(1);
    }

    public GridLayoutAssert isHorizontal() {
        return this.hasOrientation(0);
    }

    public GridLayoutAssert hasRowCount(int count) {
        this.isNotNull();
        int actualCount = ((GridLayout)this.actual).getRowCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected row count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public GridLayoutAssert isUsingDefaultMargins() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).getUseDefaultMargins()).overridingErrorMessage("Expected to be using default margins but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotUsingDefaultMargins() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).getUseDefaultMargins()).overridingErrorMessage("Expected to not be using default margins but was.", new Object[0])).isFalse();
        return this;
    }

    public GridLayoutAssert isPreservingColumnOrder() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isColumnOrderPreserved()).overridingErrorMessage("Expected to be preserving column order but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotPreservingColumnOrder() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isColumnOrderPreserved()).overridingErrorMessage("Expected to not be preserving column order but was.", new Object[0])).isFalse();
        return this;
    }

    public GridLayoutAssert isPreservingRowOrder() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isRowOrderPreserved()).overridingErrorMessage("Expected to be preserving row order but was not.", new Object[0])).isTrue();
        return this;
    }

    public GridLayoutAssert isNotPreservingRowOrder() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GridLayout)this.actual).isRowOrderPreserved()).overridingErrorMessage("Expected to not be preserving row order but was.", new Object[0])).isFalse();
        return this;
    }

    public static String alignmentModeToString(int mode) {
        return IntegerUtils.buildNamedValueString(mode).value(0, "alignBounds").value(1, "alignMargins").get();
    }

    public static String orientationToString(int orientation) {
        return IntegerUtils.buildNamedValueString(orientation).value(0, "horizontal").value(1, "vertical").get();
    }
}

