/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.FrameLayout;
import org.assertj.android.api.view.AbstractViewGroupAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractFrameLayoutAssert<S extends AbstractFrameLayoutAssert<S, A>, A extends FrameLayout>
extends AbstractViewGroupAssert<S, A> {
    protected AbstractFrameLayoutAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasForeground(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((FrameLayout)this.actual).getForeground();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected foreground drawable <%s> but was <%s>", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    @TargetApi(value=16)
    public S hasForegroundGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((FrameLayout)this.actual).getForegroundGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected foreground gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isMeasuringAllChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).getMeasureAllChildren()).overridingErrorMessage("Expected to be measuring all children but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isNotMeasuringAllChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).getMeasureAllChildren()).overridingErrorMessage("Expected to not be measuring all children but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isDelayingChildPressedState() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).shouldDelayChildPressedState()).overridingErrorMessage("Epxected to be delaying child pressed state but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    @TargetApi(value=14)
    public S isNotDelayingChildPressedState() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).shouldDelayChildPressedState()).overridingErrorMessage("Expected to not be delaying child pressed state but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }
}

