/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.animation;

import android.view.animation.GridLayoutAnimationController;
import java.util.ArrayList;
import org.assertj.android.api.view.animation.AbstractLayoutAnimationControllerAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Strings;

public class GridLayoutAnimationControllerAssert
extends AbstractLayoutAnimationControllerAssert<GridLayoutAnimationControllerAssert, GridLayoutAnimationController> {
    public GridLayoutAnimationControllerAssert(GridLayoutAnimationController actual) {
        super(actual, GridLayoutAnimationControllerAssert.class);
    }

    public GridLayoutAnimationControllerAssert hasColumnDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((GridLayoutAnimationController)this.actual).getColumnDelay();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected column delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((GridLayoutAnimationController)this.actual).getDirection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected direction <%s> but was <%s>.", new Object[]{GridLayoutAnimationControllerAssert.directionToString(direction), GridLayoutAnimationControllerAssert.directionToString(actualDirection)})).isEqualTo(direction);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasDirectionPriority(int priority) {
        this.isNotNull();
        int actualPriority = ((GridLayoutAnimationController)this.actual).getDirectionPriority();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPriority).overridingErrorMessage("Expected direction priority <%s> but was <%s>.", new Object[]{GridLayoutAnimationControllerAssert.directionPriorityToString(priority), GridLayoutAnimationControllerAssert.directionPriorityToString(actualPriority)})).isEqualTo(priority);
        return this;
    }

    public GridLayoutAnimationControllerAssert hasRowDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((GridLayoutAnimationController)this.actual).getRowDelay();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected row delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return this;
    }

    private static String directionToString(int direction) {
        ArrayList<String> parts = new ArrayList<String>();
        int horizontal = direction & 1;
        int vertical = direction & 2;
        if ((horizontal & 1) != 0) {
            parts.add("rightToLeft");
        } else {
            parts.add("leftToRight");
        }
        if ((vertical & 2) != 0) {
            parts.add("bottomToTop");
        } else {
            parts.add("topToBottom");
        }
        return Strings.join(parts).with(", ");
    }

    public static String directionPriorityToString(int priority) {
        return IntegerUtils.buildNamedValueString(priority).value(0, "none").value(1, "column").value(2, "row").get();
    }
}

