/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.animation;

import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractLayoutAnimationControllerAssert<S extends AbstractLayoutAnimationControllerAssert<S, A>, A extends LayoutAnimationController>
extends AbstractAssert<S, A> {
    protected AbstractLayoutAnimationControllerAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAnimation(Animation animation) {
        this.isNotNull();
        Animation actualAnimation = ((LayoutAnimationController)this.actual).getAnimation();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualAnimation).overridingErrorMessage("Expected animation <%s> but was <%s>.", new Object[]{animation, actualAnimation})).isSameAs((Object)animation);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((LayoutAnimationController)this.actual).getDelay();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasInterpolator(Interpolator interpolator) {
        this.isNotNull();
        Interpolator actualInterpolator = ((LayoutAnimationController)this.actual).getInterpolator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((LayoutAnimationController)this.actual).getOrder();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isDone() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).isDone()).overridingErrorMessage("Expected to be done but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isNotDone() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).isDone()).overridingErrorMessage("Expected to not be done but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isOverlapping() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).willOverlap()).overridingErrorMessage("Expected to be overlapping but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isNotOverlapping() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).willOverlap()).overridingErrorMessage("Expected to not be overlapping but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }
}

