/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view.accessibility;

import android.annotation.TargetApi;
import android.view.accessibility.AccessibilityNodeInfo;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=14)
public class AccessibilityNodeInfoAssert
extends AbstractAssert<AccessibilityNodeInfoAssert, AccessibilityNodeInfo> {
    public AccessibilityNodeInfoAssert(AccessibilityNodeInfo actual) {
        super((Object)actual, AccessibilityNodeInfoAssert.class);
    }

    public AccessibilityNodeInfoAssert hasActions(int actions) {
        this.isNotNull();
        int actualActions = ((AccessibilityNodeInfo)this.actual).getActions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualActions).overridingErrorMessage("Expected actions <%s> but was <%s>.", new Object[]{actions, actualActions})).isEqualTo(actions);
        return this;
    }

    public AccessibilityNodeInfoAssert hasChildCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityNodeInfo)this.actual).getChildCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected child count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AccessibilityNodeInfoAssert hasClassName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityNodeInfo)this.actual).getClassName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualName).overridingErrorMessage("Expected class name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AccessibilityNodeInfoAssert hasContentDescription(CharSequence description) {
        this.isNotNull();
        CharSequence actualDescription = ((AccessibilityNodeInfo)this.actual).getContentDescription();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualDescription).overridingErrorMessage("Expected content description <%s> but was <%s>.", new Object[]{description, actualDescription})).isEqualTo((Object)description);
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityNodeInfoAssert hasMovementGranularities(int granularities) {
        this.isNotNull();
        int actualGranularities = ((AccessibilityNodeInfo)this.actual).getMovementGranularities();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGranularities).overridingErrorMessage("Expected movement granularities <%s> but was <%s>.", new Object[]{granularities, actualGranularities})).isEqualTo(granularities);
        return this;
    }

    public AccessibilityNodeInfoAssert hasPackageName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityNodeInfo)this.actual).getPackageName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualName).overridingErrorMessage("Expected package name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AccessibilityNodeInfoAssert hasText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((AccessibilityNodeInfo)this.actual).getText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityNodeInfoAssert hasTextSelectionStart(int position) {
        this.isNotNull();
        int actualPosition = ((AccessibilityNodeInfo)this.actual).getTextSelectionStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected text selection start <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityNodeInfoAssert hasTextSelectionEnd(int position) {
        this.isNotNull();
        int actualPosition = ((AccessibilityNodeInfo)this.actual).getTextSelectionEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected text selection end <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityNodeInfoAssert hasViewIdResourceName(String name) {
        this.isNotNull();
        String actualName = ((AccessibilityNodeInfo)this.actual).getViewIdResourceName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected view ID resource name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AccessibilityNodeInfoAssert hasWindowId(int id) {
        this.isNotNull();
        int actualId = ((AccessibilityNodeInfo)this.actual).getWindowId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected window ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityNodeInfoAssert isAccessibilityFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isAccessibilityFocused()).overridingErrorMessage("Expected to be accessibility focused but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityNodeInfoAssert isNotAccessibilityFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isAccessibilityFocused()).overridingErrorMessage("Expected to not be accessibility focused but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isCheckable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isCheckable()).overridingErrorMessage("Expected to be checkable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotCheckable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isCheckable()).overridingErrorMessage("Expected to not be checkable but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isClickable()).overridingErrorMessage("Expected to be clickable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isClickable()).overridingErrorMessage("Expected to not be clickable but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityNodeInfoAssert isEditable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isEditable()).overridingErrorMessage("Expected to be editable but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=18)
    public AccessibilityNodeInfoAssert isNotEditable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isEditable()).overridingErrorMessage("Expected to not be editable but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isEnabled()).overridingErrorMessage("Expected to not be enabled but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isFocusable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isFocusable()).overridingErrorMessage("Expected to be focusable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotFocusable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isFocusable()).overridingErrorMessage("Expected to not be focusable but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isFocused()).overridingErrorMessage("Expected to be focused but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isFocused()).overridingErrorMessage("Expected to not be focused but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isLongClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isLongClickable()).overridingErrorMessage("Expected to be long-clickable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotLongClickable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isLongClickable()).overridingErrorMessage("Expected to not be long-clickable but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isPassword() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isPassword()).overridingErrorMessage("Expected to be password but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotPassword() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isPassword()).overridingErrorMessage("Expected to not be password but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isScrollable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isScrollable()).overridingErrorMessage("Expected to be scrollable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotScrollable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isScrollable()).overridingErrorMessage("Expected to not be scrollable but was.", new Object[0])).isFalse();
        return this;
    }

    public AccessibilityNodeInfoAssert isSelected() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isSelected()).overridingErrorMessage("Expected to be selected but was not.", new Object[0])).isTrue();
        return this;
    }

    public AccessibilityNodeInfoAssert isNotSelected() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isSelected()).overridingErrorMessage("Expected to not be selected but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityNodeInfoAssert isVisibleToUser() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isVisibleToUser()).overridingErrorMessage("Expected to be visible to user but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=16)
    public AccessibilityNodeInfoAssert isNotVisibleToUser() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AccessibilityNodeInfo)this.actual).isVisibleToUser()).overridingErrorMessage("Expected to not be visible to user but was.", new Object[0])).isFalse();
        return this;
    }
}

