/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.ViewConfiguration;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class ViewConfigurationAssert
extends AbstractAssert<ViewConfigurationAssert, ViewConfiguration> {
    public ViewConfigurationAssert(ViewConfiguration actual) {
        super((Object)actual, ViewConfigurationAssert.class);
    }

    public ViewConfigurationAssert hasScaledDoubleTapSlop(int slop) {
        this.isNotNull();
        int actualSlop = ((ViewConfiguration)this.actual).getScaledDoubleTapSlop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSlop).overridingErrorMessage("Expected scaled double-tap slop <%s> but was <%s>", new Object[]{slop, actualSlop})).isEqualTo(slop);
        return this;
    }

    public ViewConfigurationAssert hasScaledEdgeSlop(int slop) {
        this.isNotNull();
        int actualSlop = ((ViewConfiguration)this.actual).getScaledEdgeSlop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSlop).overridingErrorMessage("Expected scaled edge slop <%s> but was <%s>", new Object[]{slop, actualSlop})).isEqualTo(slop);
        return this;
    }

    public ViewConfigurationAssert hasScaledFadingEdgeLength(int length) {
        this.isNotNull();
        int actualLength = ((ViewConfiguration)this.actual).getScaledFadingEdgeLength();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected scaled fading edge length <%s> but was <%s>", new Object[]{length, actualLength})).isEqualTo(length);
        return this;
    }

    public ViewConfigurationAssert hasScaledMaximumDrawingCacheSize(int size) {
        this.isNotNull();
        int actualSize = ((ViewConfiguration)this.actual).getScaledMaximumDrawingCacheSize();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected scaled maximum drawing cache size <%s> but was <%s>", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public ViewConfigurationAssert hasScaledMaximumFlingVelocity(int velocity) {
        this.isNotNull();
        int actualVelocity = ((ViewConfiguration)this.actual).getScaledMaximumFlingVelocity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVelocity).overridingErrorMessage("Expected scaled maximum fling velocity <%s> but was <%s>", new Object[]{velocity, actualVelocity})).isEqualTo(velocity);
        return this;
    }

    public ViewConfigurationAssert hasScaledMinimumFlingVelocity(int velocity) {
        this.isNotNull();
        int actualVelocity = ((ViewConfiguration)this.actual).getScaledMinimumFlingVelocity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualVelocity).overridingErrorMessage("Expected scaled minimum fling velocity <%s> but was <%s>", new Object[]{velocity, actualVelocity})).isEqualTo(velocity);
        return this;
    }

    @TargetApi(value=9)
    public ViewConfigurationAssert hasScaledOverflingDistance(int distance) {
        this.isNotNull();
        int actualDistance = ((ViewConfiguration)this.actual).getScaledOverflingDistance();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDistance).overridingErrorMessage("Expected scaled overfling distance <%s> but was <%s>", new Object[]{distance, actualDistance})).isEqualTo(distance);
        return this;
    }

    @TargetApi(value=9)
    public ViewConfigurationAssert hasScaledOverscrollDistance(int distance) {
        this.isNotNull();
        int actualDistance = ((ViewConfiguration)this.actual).getScaledOverscrollDistance();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDistance).overridingErrorMessage("Expected scaled overscroll distance <%s> but was <%s>", new Object[]{distance, actualDistance})).isEqualTo(distance);
        return this;
    }

    @TargetApi(value=8)
    public ViewConfigurationAssert hasScaledPagingTouchSlop(int slop) {
        this.isNotNull();
        int actualSlop = ((ViewConfiguration)this.actual).getScaledPagingTouchSlop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSlop).overridingErrorMessage("Expected scaled paging touch slop <%s> but was <%s>", new Object[]{slop, actualSlop})).isEqualTo(slop);
        return this;
    }

    public ViewConfigurationAssert hasScaledScrollBarSize(int size) {
        this.isNotNull();
        int actualSize = ((ViewConfiguration)this.actual).getScaledScrollBarSize();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected scaled scroll bar size <%s> but was <%s>", new Object[]{size, actualSize})).isEqualTo(size);
        return this;
    }

    public ViewConfigurationAssert hasScaledTouchSlop(int slop) {
        this.isNotNull();
        int actualSlop = ((ViewConfiguration)this.actual).getScaledTouchSlop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSlop).overridingErrorMessage("Expected scaled touch slop <%s> but was <%s>", new Object[]{slop, actualSlop})).isEqualTo(slop);
        return this;
    }

    public ViewConfigurationAssert hasScaledWindowTouchSlop(int slop) {
        this.isNotNull();
        int actualSlop = ((ViewConfiguration)this.actual).getScaledWindowTouchSlop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSlop).overridingErrorMessage("Expected scaled window touch slop <%s> but was <%s>", new Object[]{slop, actualSlop})).isEqualTo(slop);
        return this;
    }
}

