/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.VelocityTracker;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;

public class VelocityTrackerAssert
extends AbstractAssert<VelocityTrackerAssert, VelocityTracker> {
    public VelocityTrackerAssert(VelocityTracker actual) {
        super((Object)actual, VelocityTrackerAssert.class);
    }

    public VelocityTrackerAssert hasXVelocity(float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getXVelocity();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected X velocity <%s> but was <%s>", new Object[]{Float.valueOf(velocity), Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    @TargetApi(value=8)
    public VelocityTrackerAssert hasXVelocity(int id, float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getXVelocity(id);
        ((AbstractFloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected X velocity <%s> with ID %s but was <%s>", new Object[]{Float.valueOf(velocity), id, Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    public VelocityTrackerAssert hasYVelocity(float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getYVelocity();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected Y velocity <%s> but was <%s>", new Object[]{Float.valueOf(velocity), Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }

    @TargetApi(value=8)
    public VelocityTrackerAssert hasYVelocity(int id, float velocity) {
        this.isNotNull();
        float actualVelocity = ((VelocityTracker)this.actual).getYVelocity(id);
        ((AbstractFloatAssert)Assertions.assertThat((float)actualVelocity).overridingErrorMessage("Expected Y velocity <%s> with ID %s but was <%s>", new Object[]{Float.valueOf(velocity), id, Float.valueOf(actualVelocity)})).isEqualTo(velocity);
        return this;
    }
}

