/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.ScaleGestureDetector;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=8)
public class ScaleGestureDetectorAssert
extends AbstractAssert<ScaleGestureDetectorAssert, ScaleGestureDetector> {
    public ScaleGestureDetectorAssert(ScaleGestureDetector actual) {
        super((Object)actual, ScaleGestureDetectorAssert.class);
    }

    public ScaleGestureDetectorAssert hasCurrentSpan(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getCurrentSpan();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected current span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    @TargetApi(value=11)
    public ScaleGestureDetectorAssert hasCurrentSpanX(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getCurrentSpanX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected current X span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    @TargetApi(value=11)
    public ScaleGestureDetectorAssert hasCurrentSpanY(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getCurrentSpanY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected current Y span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    public ScaleGestureDetectorAssert hasEventTime(long time) {
        this.isNotNull();
        long actualTime = ((ScaleGestureDetector)this.actual).getEventTime();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected event time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public ScaleGestureDetectorAssert hasFocusX(float focus) {
        this.isNotNull();
        float actualFocus = ((ScaleGestureDetector)this.actual).getFocusX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualFocus).overridingErrorMessage("Expected X focus <%s> but was <%s>.", new Object[]{Float.valueOf(focus), Float.valueOf(actualFocus)})).isEqualTo(focus);
        return this;
    }

    public ScaleGestureDetectorAssert hasFocusY(float focus) {
        this.isNotNull();
        float actualFocus = ((ScaleGestureDetector)this.actual).getFocusY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualFocus).overridingErrorMessage("Expected Y focus <%s> but was <%s>.", new Object[]{Float.valueOf(focus), Float.valueOf(actualFocus)})).isEqualTo(focus);
        return this;
    }

    public ScaleGestureDetectorAssert hasPreviousSpan(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getPreviousSpan();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected previous span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    @TargetApi(value=11)
    public ScaleGestureDetectorAssert hasPreviousSpanX(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getPreviousSpanX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected previous X span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    @TargetApi(value=11)
    public ScaleGestureDetectorAssert hasPreviousSpanY(float span) {
        this.isNotNull();
        float actualSpan = ((ScaleGestureDetector)this.actual).getPreviousSpanY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualSpan).overridingErrorMessage("Expected previous Y span <%s> but was <%s>.", new Object[]{Float.valueOf(span), Float.valueOf(actualSpan)})).isEqualTo(span);
        return this;
    }

    public ScaleGestureDetectorAssert hasScaleFactor(float factor) {
        this.isNotNull();
        float actualFactor = ((ScaleGestureDetector)this.actual).getScaleFactor();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualFactor).overridingErrorMessage("Expected scale factor <%s> but was <%s>.", new Object[]{Float.valueOf(factor), Float.valueOf(actualFactor)})).isEqualTo(factor);
        return this;
    }

    public ScaleGestureDetectorAssert hasTimeDelta(long delta) {
        this.isNotNull();
        long actualDelta = ((ScaleGestureDetector)this.actual).getTimeDelta();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDelta).overridingErrorMessage("Expected time delta <%s> but was <%s>.", new Object[]{delta, actualDelta})).isEqualTo(delta);
        return this;
    }

    public ScaleGestureDetectorAssert isInProgress() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScaleGestureDetector)this.actual).isInProgress()).overridingErrorMessage("Expected to be in progress but was not in progress.", new Object[0])).isTrue();
        return this;
    }

    public ScaleGestureDetectorAssert isNotInProgress() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScaleGestureDetector)this.actual).isInProgress()).overridingErrorMessage("Expected to not be in progress but was in progress.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=19)
    public ScaleGestureDetectorAssert isQuickScaleEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScaleGestureDetector)this.actual).isQuickScaleEnabled()).overridingErrorMessage("Expected to have quick scale enabled but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=19)
    public ScaleGestureDetectorAssert isQuickScaleDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ScaleGestureDetector)this.actual).isQuickScaleEnabled()).overridingErrorMessage("Expected to have quick scale disabled but was not.", new Object[0])).isFalse();
        return this;
    }
}

