/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.MenuItem;
import android.view.View;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class MenuItemAssert
extends AbstractAssert<MenuItemAssert, MenuItem> {
    public MenuItemAssert(MenuItem actual) {
        super((Object)actual, MenuItemAssert.class);
    }

    @TargetApi(value=11)
    public MenuItemAssert hasActionView(View view) {
        this.isNotNull();
        View actualView = ((MenuItem)this.actual).getActionView();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected action view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public MenuItemAssert hasAlphabeticShortcut(char shortcut) {
        this.isNotNull();
        char actualShortcut = ((MenuItem)this.actual).getAlphabeticShortcut();
        ((AbstractCharacterAssert)Assertions.assertThat((char)actualShortcut).overridingErrorMessage("Expected alphabetic shortcut <%s> but was <%s>.", new Object[]{Character.valueOf(shortcut), Character.valueOf(actualShortcut)})).isEqualTo(shortcut);
        return this;
    }

    public MenuItemAssert hasGroupId(int id) {
        this.isNotNull();
        int actualId = ((MenuItem)this.actual).getGroupId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected group ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public MenuItemAssert hasIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((MenuItem)this.actual).getIcon();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return this;
    }

    public MenuItemAssert hasIntent(Intent intent) {
        this.isNotNull();
        Intent actualIntent = ((MenuItem)this.actual).getIntent();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualIntent).overridingErrorMessage("Expected intent <%s> but was <%s>.", new Object[]{intent, actualIntent})).isEqualTo((Object)intent);
        return this;
    }

    public MenuItemAssert hasItemId(int id) {
        this.isNotNull();
        int actualId = ((MenuItem)this.actual).getItemId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected item ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public MenuItemAssert hasNumericShortcut(char shortcut) {
        this.isNotNull();
        char actualShortcut = ((MenuItem)this.actual).getNumericShortcut();
        ((AbstractCharacterAssert)Assertions.assertThat((char)actualShortcut).overridingErrorMessage("Expected numeric shortcut <%s> but was <%s>.", new Object[]{Character.valueOf(shortcut), Character.valueOf(actualShortcut)})).isEqualTo(shortcut);
        return this;
    }

    public MenuItemAssert hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((MenuItem)this.actual).getOrder();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return this;
    }

    public MenuItemAssert hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((MenuItem)this.actual).getTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public MenuItemAssert hasCondensedTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((MenuItem)this.actual).getTitleCondensed();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected condensed title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return this;
    }

    public MenuItemAssert hasSubMenu() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).hasSubMenu()).overridingErrorMessage("Expected to have sub-menu but sub-menu was not present.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert hasNoSubMenu() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).hasSubMenu()).overridingErrorMessage("Expected to not have a sub-menu but sub-menu was present.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=14)
    public MenuItemAssert isActionViewExpanded() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isActionViewExpanded()).overridingErrorMessage("Expected expanded action view but action view was collapsed.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=14)
    public MenuItemAssert isActionViewCollapsed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isActionViewExpanded()).overridingErrorMessage("Expected collapsed action view but action view was expanded.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isCheckable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isCheckable()).overridingErrorMessage("Expected to be checkable but was not checkable.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotCheckable() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isCheckable()).overridingErrorMessage("Expected to not be checkable but was checkable.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not checked.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotChecked() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was checked.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public MenuItemAssert isVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isVisible()).overridingErrorMessage("Expected to be visible but was not visible.", new Object[0])).isTrue();
        return this;
    }

    public MenuItemAssert isNotVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MenuItem)this.actual).isVisible()).overridingErrorMessage("Expected to not be visible but was visible.", new Object[0])).isFalse();
        return this;
    }
}

