/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.Display;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class DisplayAssert
extends AbstractAssert<DisplayAssert, Display> {
    public DisplayAssert(Display actual) {
        super((Object)actual, DisplayAssert.class);
    }

    public DisplayAssert hasDisplayId(int id) {
        this.isNotNull();
        int actualId = ((Display)this.actual).getDisplayId();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(actualId);
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert hasFlag(int flag) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)(((Display)this.actual).getFlags() & flag)).overridingErrorMessage("Expected flag <%s> but was not present", new Object[]{flag})).isNotZero();
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert hasFlags(int flags) {
        this.isNotNull();
        int actualFlags = ((Display)this.actual).getFlags();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFlags).overridingErrorMessage("Expected flags <%s> but was <%s>", new Object[]{DisplayAssert.flagsToString(flags), DisplayAssert.flagsToString(actualFlags)})).isEqualTo(flags);
        return this;
    }

    public DisplayAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Display)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((Display)this.actual).getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public DisplayAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((Display)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>", new Object[]{DisplayAssert.orientationToString(orientation), DisplayAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return this;
    }

    public DisplayAssert isPortrait() {
        this.isNotNull();
        int actualOrientation = ((Display)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> or <%s>, but was <%s>", new Object[]{DisplayAssert.orientationToString(0), DisplayAssert.orientationToString(2), DisplayAssert.orientationToString(actualOrientation)})).isIn(new Object[]{0, 2});
        return this;
    }

    public DisplayAssert isLandscape() {
        this.isNotNull();
        int actualOrientation = ((Display)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> or <%s>, but was <%s>", new Object[]{DisplayAssert.orientationToString(3), DisplayAssert.orientationToString(1), DisplayAssert.orientationToString(actualOrientation)})).isIn(new Object[]{3, 1});
        return this;
    }

    public DisplayAssert hasPixelFormat(int format) {
        this.isNotNull();
        int actualFormat = ((Display)this.actual).getPixelFormat();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFormat).overridingErrorMessage("Expected pixel format <%s> but was <%s>", new Object[]{DisplayAssert.pixelFormatToString(format), DisplayAssert.pixelFormatToString(actualFormat)})).isEqualTo(format);
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert hasRealSize(int width, int height) {
        this.isNotNull();
        Point actualSize = new Point();
        ((Display)this.actual).getRealSize(actualSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize.x).overridingErrorMessage("Expected real size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(width);
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize.y).overridingErrorMessage("Expected real size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(height);
        return this;
    }

    public DisplayAssert hasRefreshRate(float rate) {
        this.isNotNull();
        float actualRate = ((Display)this.actual).getRefreshRate();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualRate).overridingErrorMessage("Expected refresh rate <%s> but was <%s>", new Object[]{Float.valueOf(rate), Float.valueOf(actualRate)})).isEqualTo(rate);
        return this;
    }

    @TargetApi(value=8)
    public DisplayAssert hasRotation(int rotation) {
        this.isNotNull();
        int actualRotation = ((Display)this.actual).getRotation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRotation).overridingErrorMessage("Expected rotation <%s> but was <%s>", new Object[]{rotation, actualRotation})).isEqualTo(rotation);
        return this;
    }

    @TargetApi(value=13)
    public DisplayAssert hasSize(int width, int height) {
        this.isNotNull();
        Point actualSize = new Point();
        ((Display)this.actual).getSize(actualSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize.x).overridingErrorMessage("Expected size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(width);
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize.y).overridingErrorMessage("Expected size of <%s, %s> but was <%s, %s>", new Object[]{width, height, actualSize.x, actualSize.y})).isEqualTo(height);
        return this;
    }

    @TargetApi(value=20)
    public DisplayAssert hasState(int state) {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Display)this.actual).getState()).overridingErrorMessage("Expected state <%s> but was <%s>", new Object[]{DisplayAssert.stateToString(state), DisplayAssert.stateToString(((Display)this.actual).getState())})).isEqualTo(state);
        return this;
    }

    public DisplayAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Display)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert isValid() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Display)this.actual).isValid()).overridingErrorMessage("Expected valid but was not valid", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=17)
    public DisplayAssert isNotValid() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Display)this.actual).isValid()).overridingErrorMessage("Expected invalid but was valid", new Object[0])).isFalse();
        return this;
    }

    public static String orientationToString(int orientation) {
        return IntegerUtils.buildNamedValueString(orientation).value(0, "portrait (0)").value(1, "landscape (90)").value(2, "inverted portrait (180)").value(3, "inverted landscape (270)").get();
    }

    @TargetApi(value=20)
    public static String stateToString(int state) {
        return IntegerUtils.buildNamedValueString(state).value(3, "dozing").value(4, "doze suspend").value(1, "off").value(2, "on").value(0, "unknown").get();
    }

    public static String flagsToString(int flags) {
        return IntegerUtils.buildBitMaskString(flags).flag(8, "presentation").flag(4, "private").flag(2, "secure").flag(1, "supports_protected_buffers").get();
    }

    public static String pixelFormatToString(int format) {
        return IntegerUtils.buildNamedValueString(format).value(0, "unknown").value(-3, "translucent").value(-2, "transparent").value(-1, "opaque").value(1, "rgba_8888").value(2, "rgbx_8888").value(3, "rgb_888").value(4, "rgb_565").value(6, "rgba_5551").value(7, "rgba_4444").value(8, "a_8").value(9, "l_8").value(10, "la_88").value(11, "rgb_332").value(16, "ycbcr_422_sp").value(17, "ycbcr_420_sp").value(20, "ycbcr_422_i").value(256, "jpeg").get();
    }
}

