/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.view;

import android.annotation.TargetApi;
import android.view.View;
import android.view.ViewGroup;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractViewGroupAssert<S extends AbstractViewGroupAssert<S, A>, A extends ViewGroup>
extends AbstractViewAssert<S, A> {
    protected AbstractViewGroupAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S isAddingStatesFromChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).addStatesFromChildren()).overridingErrorMessage("Expected adding states from children but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isNotAddingStatesFromChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).addStatesFromChildren()).overridingErrorMessage("Expected not adding states from children but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasChildCount(int count) {
        this.isNotNull();
        int actualCount = ((ViewGroup)this.actual).getChildCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected child count <%s> but was <%s>", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasDescendantFocusability(int focusability) {
        this.isNotNull();
        int actualFocusability = ((ViewGroup)this.actual).getDescendantFocusability();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualFocusability).overridingErrorMessage("Expected descendant focusability <%s> but was <%s>", new Object[]{AbstractViewGroupAssert.descendantFocusabilityToString(focusability), AbstractViewGroupAssert.descendantFocusabilityToString(actualFocusability)})).isEqualTo(focusability);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasFocusedChild(View view) {
        this.isNotNull();
        View actualView = ((ViewGroup)this.actual).getFocusedChild();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected focused child <%s> but was <%s>", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    @TargetApi(value=18)
    public S hasLayoutMode(int layoutMode) {
        this.isNotNull();
        int actualLayoutMode = ((ViewGroup)this.actual).getLayoutMode();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLayoutMode).overridingErrorMessage("Expected layout mode <%s> but was <%s>.", new Object[]{AbstractViewGroupAssert.layoutModeToString(layoutMode), AbstractViewGroupAssert.layoutModeToString(actualLayoutMode)})).isEqualTo(layoutMode);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasPersistentDrawingCache(int cache) {
        this.isNotNull();
        int actualCache = ((ViewGroup)this.actual).getPersistentDrawingCache();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCache).overridingErrorMessage("Expected persistent drawing cache <%s> but was <%s>", new Object[]{AbstractViewGroupAssert.persistentDrawingCacheToString(cache), AbstractViewGroupAssert.persistentDrawingCacheToString(actualCache)})).isEqualTo(cache);
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isAlwaysDrawnWithCache() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAlwaysDrawnWithCacheEnabled()).overridingErrorMessage("Expected to always draw with cache but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S isNotAlwaysDrawnWithCache() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAlwaysDrawnWithCacheEnabled()).overridingErrorMessage("Expected to not always draw with cache but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isClippingChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).getClipChildren()).overridingErrorMessage("Expected to be clipping children but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isNotClippingChildren() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).getClipChildren()).overridingErrorMessage("Expected to not be clipping children but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasAnimationCacheEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAnimationCacheEnabled()).overridingErrorMessage("Expected animation cache enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public S hasAnimationCacheDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isAnimationCacheEnabled()).overridingErrorMessage("Expected animation cache disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasMotionEventSplittingEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isMotionEventSplittingEnabled()).overridingErrorMessage("Expected motion event splitting enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasMotionEventSplittingDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ViewGroup)this.actual).isMotionEventSplittingEnabled()).overridingErrorMessage("Expected motion event splitting disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewGroupAssert)this.myself));
    }

    public static String descendantFocusabilityToString(int focusability) {
        return IntegerUtils.buildNamedValueString(focusability).value(262144, "afterDescendants").value(131072, "beforeDescendants").value(393216, "blockDescendants").get();
    }

    public static String persistentDrawingCacheToString(int cache) {
        return IntegerUtils.buildNamedValueString(cache).value(3, "all").value(1, "animation").value(0, "none").value(2, "scrolling").get();
    }

    public static String layoutModeToString(int layoutMode) {
        return IntegerUtils.buildNamedValueString(layoutMode).value(0, "clip_bounds").value(1, "optical_bounds").get();
    }
}

