/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.telephony;

import android.telephony.NeighboringCellInfo;
import org.assertj.android.api.telephony.TelephonyManagerAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class NeighboringCellInfoAssert
extends AbstractAssert<NeighboringCellInfoAssert, NeighboringCellInfo> {
    public NeighboringCellInfoAssert(NeighboringCellInfo actual) {
        super((Object)actual, NeighboringCellInfoAssert.class);
    }

    public NeighboringCellInfoAssert hasCid(int cid) {
        this.isNotNull();
        int actualCid = ((NeighboringCellInfo)this.actual).getCid();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCid).overridingErrorMessage("Expected CID <%s> but was <%s>.", new Object[]{cid, actualCid})).isEqualTo(cid);
        return this;
    }

    public NeighboringCellInfoAssert hasLac(int lac) {
        this.isNotNull();
        int actualLac = ((NeighboringCellInfo)this.actual).getLac();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLac).overridingErrorMessage("Expected LAC <%s> but was <%s>.", new Object[]{lac, actualLac})).isEqualTo(lac);
        return this;
    }

    public NeighboringCellInfoAssert hasNetworkType(int networkType) {
        this.isNotNull();
        int actualNetworkType = ((NeighboringCellInfo)this.actual).getNetworkType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualNetworkType).overridingErrorMessage("Expected network type <%s> but was <%s>.", new Object[]{TelephonyManagerAssert.networkTypeToString(networkType), TelephonyManagerAssert.networkTypeToString(actualNetworkType)})).isEqualTo(networkType);
        return this;
    }

    public NeighboringCellInfoAssert hasPsc(int psc) {
        this.isNotNull();
        int actualPsc = ((NeighboringCellInfo)this.actual).getPsc();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPsc).overridingErrorMessage("Expected PSC <%s> but was <%s>.", new Object[]{psc, actualPsc})).isEqualTo(psc);
        return this;
    }

    public NeighboringCellInfoAssert hasRssi(int rssi) {
        this.isNotNull();
        int actualRssi = ((NeighboringCellInfo)this.actual).getRssi();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRssi).overridingErrorMessage("Expected RSSI <%s> but was <%s>.", new Object[]{rssi, actualRssi})).isEqualTo(rssi);
        return this;
    }
}

