/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.preference;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.graphics.drawable.Drawable;
import android.preference.DialogPreference;
import org.assertj.android.api.preference.AbstractPreferenceAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractDialogPreferenceAssert<S extends AbstractDialogPreferenceAssert<S, A>, A extends DialogPreference>
extends AbstractPreferenceAssert<S, A> {
    protected AbstractDialogPreferenceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDialog(Dialog dialog) {
        this.isNotNull();
        Dialog actualDialog = ((DialogPreference)this.actual).getDialog();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDialog).overridingErrorMessage("Expected dialog <%s> but was <%s>.", new Object[]{dialog, actualDialog})).isSameAs((Object)dialog);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    @TargetApi(value=11)
    public S hasDialogIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((DialogPreference)this.actual).getIcon();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected dialog icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((DialogPreference)this.actual).getDialogLayoutResource();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected dialog layout resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogMessage(CharSequence message) {
        this.isNotNull();
        CharSequence actualMessage = ((DialogPreference)this.actual).getDialogMessage();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualMessage).overridingErrorMessage("Expected dialog message <%s> but was <%s>.", new Object[]{message, actualMessage})).isEqualTo((Object)message);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogMessage(int resId) {
        this.isNotNull();
        return this.hasDialogMessage(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasDialogTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((DialogPreference)this.actual).getDialogTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected dialog title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogTitle(int resId) {
        this.isNotNull();
        return this.hasDialogTitle(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasNegativeButtonText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((DialogPreference)this.actual).getNegativeButtonText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected negative button text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasNegativeButtonText(int resId) {
        this.isNotNull();
        return this.hasNegativeButtonText(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasPositiveButtonText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((DialogPreference)this.actual).getPositiveButtonText();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected positive button text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasPositiveButtonText(int resId) {
        this.isNotNull();
        return this.hasPositiveButtonText(((DialogPreference)this.actual).getContext().getString(resId));
    }
}

