/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.net;

import android.net.Uri;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public final class UriAssert
extends AbstractAssert<UriAssert, Uri> {
    public UriAssert(Uri actual) {
        super((Object)actual, UriAssert.class);
    }

    public UriAssert hasPath(String path) {
        this.isNotNull();
        String actualPath = ((Uri)this.actual).getPath();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPath).overridingErrorMessage("Expected path <%s> but was <%s>.", new Object[]{path, actualPath})).isEqualTo((Object)path);
        return this;
    }

    public UriAssert hasNoPath(String action) {
        this.isNotNull();
        String actualPath = ((Uri)this.actual).getPath();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPath).overridingErrorMessage("Expected no path but was <%s>.", new Object[]{actualPath})).isNull();
        return this;
    }

    public UriAssert hasPort(int port) {
        this.isNotNull();
        int actualPort = ((Uri)this.actual).getPort();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPort).overridingErrorMessage("Expected port <%d> but was <%s>.", new Object[]{port, actualPort})).isEqualTo(port);
        return this;
    }

    public UriAssert hasHost(String host) {
        this.isNotNull();
        String actualHost = ((Uri)this.actual).getHost();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualHost).overridingErrorMessage("Expected host <%s> but was <%s>.", new Object[]{host, actualHost})).isEqualTo((Object)host);
        return this;
    }

    public UriAssert hasFragment(String fragment) {
        this.isNotNull();
        String actualFragment = ((Uri)this.actual).getFragment();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualFragment).overridingErrorMessage("Expected fragment <%s> but was <%s>.", new Object[]{fragment, actualFragment})).isEqualTo((Object)fragment);
        return this;
    }

    public UriAssert hasNoFragment() {
        this.isNotNull();
        String actualFragment = ((Uri)this.actual).getFragment();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualFragment).overridingErrorMessage("Expected no fragment but was <%s>.", new Object[]{actualFragment})).isNull();
        return this;
    }

    public UriAssert hasQuery(String query) {
        this.isNotNull();
        String actualQuery = ((Uri)this.actual).getQuery();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualQuery).overridingErrorMessage("Expected query <%s> but was <%s>.", new Object[]{query, actualQuery})).isEqualTo((Object)query);
        return this;
    }

    public UriAssert hasNoQuery() {
        this.isNotNull();
        String actualQuery = ((Uri)this.actual).getQuery();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((Uri)this.actual).getQuery()).overridingErrorMessage("Expected no query but was <%s>.", new Object[]{actualQuery})).isNull();
        return this;
    }

    public UriAssert hasScheme(String scheme) {
        this.isNotNull();
        String actualScheme = ((Uri)this.actual).getScheme();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualScheme).overridingErrorMessage("Expected scheme <%s> but was <%s>.", new Object[]{scheme, actualScheme})).isEqualTo((Object)scheme);
        return this;
    }

    public UriAssert hasUserInfo(String userInfo) {
        this.isNotNull();
        String actualUserInfo = ((Uri)this.actual).getUserInfo();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUserInfo).overridingErrorMessage("Expected userInfo <%s> but was <%s>.", new Object[]{userInfo, actualUserInfo})).isEqualTo((Object)userInfo);
        return this;
    }

    public UriAssert hasNoUserInfo() {
        this.isNotNull();
        String actualUserInfo = ((Uri)this.actual).getUserInfo();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUserInfo).overridingErrorMessage("Expected no userInfo but was <%s>.", new Object[]{actualUserInfo})).isNull();
        return this;
    }
}

