/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.location;

import android.annotation.TargetApi;
import android.location.Criteria;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class CriteriaAssert
extends AbstractAssert<CriteriaAssert, Criteria> {
    public CriteriaAssert(Criteria actual) {
        super((Object)actual, CriteriaAssert.class);
    }

    public CriteriaAssert hasAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getAccuracy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyRequirementToString(accuracy), CriteriaAssert.accuracyRequirementToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    @TargetApi(value=9)
    public CriteriaAssert hasBearingAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getBearingAccuracy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected bearing accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    @TargetApi(value=9)
    public CriteriaAssert hasHorizontalAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getHorizontalAccuracy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected horizontal accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert hasPowerRequirement(int requirement) {
        this.isNotNull();
        int actualRequirement = ((Criteria)this.actual).getPowerRequirement();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRequirement).overridingErrorMessage("Expected power requirement <%s> but was <%s>.", new Object[]{CriteriaAssert.powerRequirementToString(requirement), CriteriaAssert.powerRequirementToString(actualRequirement)})).isEqualTo(requirement);
        return this;
    }

    @TargetApi(value=9)
    public CriteriaAssert hasSpeedAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getSpeedAccuracy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected speed accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    @TargetApi(value=9)
    public CriteriaAssert hasVerticalAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((Criteria)this.actual).getVerticalAccuracy();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected vertical accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyToString(accuracy), CriteriaAssert.accuracyToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public CriteriaAssert isAltitudeRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isAltitudeRequired()).overridingErrorMessage("Expected altitude to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isAltitudeNotRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isAltitudeRequired()).overridingErrorMessage("Expected altitude to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isBearingRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isBearingRequired()).overridingErrorMessage("Expected bearing to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isBearingNotRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isBearingRequired()).overridingErrorMessage("Expected bearing to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isCostAllowed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isCostAllowed()).overridingErrorMessage("Expected cost to be allowed but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isCostNotAllowed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isCostAllowed()).overridingErrorMessage("Expected cost to not be allowed but was.", new Object[0])).isFalse();
        return this;
    }

    public CriteriaAssert isSpeedRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isSpeedRequired()).overridingErrorMessage("Expected speed to be required but was not.", new Object[0])).isTrue();
        return this;
    }

    public CriteriaAssert isSpeedNotRequired() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Criteria)this.actual).isSpeedRequired()).overridingErrorMessage("Expected speed to not be required but was.", new Object[0])).isFalse();
        return this;
    }

    public static String accuracyRequirementToString(int accuracy) {
        return IntegerUtils.buildNamedValueString(accuracy).value(2, "coarse").value(1, "fine").get();
    }

    public static String accuracyToString(int accuracy) {
        return IntegerUtils.buildNamedValueString(accuracy).value(3, "high").value(2, "medium").value(1, "low").get();
    }

    public static String powerRequirementToString(int requirement) {
        return IntegerUtils.buildNamedValueString(requirement).value(0, "none").value(1, "low").value(2, "medium").value(3, "high").get();
    }
}

