/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.location;

import android.location.Address;
import java.util.Locale;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class AddressAssert
extends AbstractAssert<AddressAssert, Address> {
    public AddressAssert(Address actual) {
        super((Object)actual, AddressAssert.class);
    }

    public AddressAssert hasAddressLine(int index, String line) {
        this.isNotNull();
        String actualLine = ((Address)this.actual).getAddressLine(index);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualLine).overridingErrorMessage("Expected address line %s <%s> but was <%s>.", new Object[]{index, line, actualLine})).isEqualTo((Object)line);
        return this;
    }

    public AddressAssert hasAdminArea(String area) {
        this.isNotNull();
        String actualArea = ((Address)this.actual).getAdminArea();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualArea).overridingErrorMessage("Expected admin area <%s> but was <%s>.", new Object[]{area, actualArea})).isEqualTo((Object)area);
        return this;
    }

    public AddressAssert hasCountryCode(String code) {
        this.isNotNull();
        String actualCode = ((Address)this.actual).getCountryCode();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualCode).overridingErrorMessage("Expected country code <%s> but was <%s>.", new Object[]{code, actualCode})).isEqualTo((Object)code);
        return this;
    }

    public AddressAssert hasCountryName(String name) {
        this.isNotNull();
        String actualName = ((Address)this.actual).getCountryName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected country name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AddressAssert hasFeatureName(String name) {
        this.isNotNull();
        String actualName = ((Address)this.actual).getFeatureName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected feature name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AddressAssert hasLatitude(double latitude) {
        this.isNotNull();
        double actualLatitude = ((Address)this.actual).getLatitude();
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualLatitude).overridingErrorMessage("Expected latitude <%s> but was <%s>.", new Object[]{latitude, actualLatitude})).isEqualTo(latitude);
        return this;
    }

    public AddressAssert hasLocale(Locale locale) {
        this.isNotNull();
        Locale actualLocale = ((Address)this.actual).getLocale();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualLocale).overridingErrorMessage("Expected locale <%s> but was <%s>.", new Object[]{locale, actualLocale})).isEqualTo((Object)locale);
        return this;
    }

    public AddressAssert hasLocality(String locality) {
        this.isNotNull();
        String actualLocality = ((Address)this.actual).getLocality();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualLocality).overridingErrorMessage("Expected locality <%s> but was <%s>.", new Object[]{locality, actualLocality})).isEqualTo((Object)locality);
        return this;
    }

    public AddressAssert hasLongitude(double longitude) {
        this.isNotNull();
        double actualLongitude = ((Address)this.actual).getLongitude();
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualLongitude).overridingErrorMessage("Expected latitude <%s> but was <%s>.", new Object[]{longitude, actualLongitude})).isEqualTo(longitude);
        return this;
    }

    public AddressAssert hasMaximumAddressLineIndex(int index) {
        this.isNotNull();
        int actualIndex = ((Address)this.actual).getMaxAddressLineIndex();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected maximum address line index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AddressAssert hasPhone(String phone) {
        this.isNotNull();
        String actualPhone = ((Address)this.actual).getPhone();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPhone).overridingErrorMessage("Expected phone <%s> but was <%s>.", new Object[]{phone, actualPhone})).isEqualTo((Object)phone);
        return this;
    }

    public AddressAssert hasPostalCode(String code) {
        this.isNotNull();
        String actualCode = ((Address)this.actual).getPostalCode();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualCode).overridingErrorMessage("Expected postal code <%s> but was <%s>.", new Object[]{code, actualCode})).isEqualTo((Object)code);
        return this;
    }

    public AddressAssert hasPremises(String premises) {
        this.isNotNull();
        String actualPremises = ((Address)this.actual).getPremises();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualPremises).overridingErrorMessage("Expected premises <%s> but was <%s>.", new Object[]{premises, actualPremises})).isEqualTo((Object)premises);
        return this;
    }

    public AddressAssert hasSubAdminArea(String area) {
        this.isNotNull();
        String actualArea = ((Address)this.actual).getSubAdminArea();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualArea).overridingErrorMessage("Expected sub-admin area <%s> but was <%s>.", new Object[]{area, actualArea})).isEqualTo((Object)area);
        return this;
    }

    public AddressAssert hasSubLocality(String locality) {
        this.isNotNull();
        String actualLocality = ((Address)this.actual).getSubLocality();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualLocality).overridingErrorMessage("Expected sub-locality <%s> but was <%s>.", new Object[]{locality, actualLocality})).isEqualTo((Object)locality);
        return this;
    }

    public AddressAssert hasThoroughfare(String thoroughfare) {
        this.isNotNull();
        String actualThoroughfare = ((Address)this.actual).getThoroughfare();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualThoroughfare).overridingErrorMessage("Expected thoroughfare <%s> but was <%s>.", new Object[]{thoroughfare, actualThoroughfare})).isEqualTo((Object)thoroughfare);
        return this;
    }

    public AddressAssert hasUrl(String url) {
        this.isNotNull();
        String actualUrl = ((Address)this.actual).getUrl();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualUrl).overridingErrorMessage("Expected url <%s> but was <%s>.", new Object[]{url, actualUrl})).isEqualTo((Object)url);
        return this;
    }

    public AddressAssert hasLatitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Address)this.actual).hasLatitude()).overridingErrorMessage("Expected to have latitude but did not.", new Object[0])).isTrue();
        return this;
    }

    public AddressAssert hasNoLatitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Address)this.actual).hasLatitude()).overridingErrorMessage("Expected to not have latitude but did.", new Object[0])).isFalse();
        return this;
    }

    public AddressAssert hasLongitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Address)this.actual).hasLongitude()).overridingErrorMessage("Expected to have longitude but did not.", new Object[0])).isTrue();
        return this;
    }

    public AddressAssert hasNoLongitude() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Address)this.actual).hasLongitude()).overridingErrorMessage("Expected to not have longitude but did.", new Object[0])).isFalse();
        return this;
    }
}

