/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics.drawable.shapes;

import android.graphics.drawable.shapes.Shape;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;

public class ShapeAssert
extends AbstractAssert<ShapeAssert, Shape> {
    public ShapeAssert(Shape actual) {
        super((Object)actual, ShapeAssert.class);
    }

    public ShapeAssert hasHeight(float height) {
        this.isNotNull();
        float actualHeight = ((Shape)this.actual).getHeight();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{Float.valueOf(height), Float.valueOf(actualHeight)})).isEqualTo(height);
        return this;
    }

    public ShapeAssert hasWidth(float width) {
        this.isNotNull();
        float actualHeight = ((Shape)this.actual).getWidth();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{Float.valueOf(width), Float.valueOf(actualHeight)})).isEqualTo(width);
        return this;
    }

    public ShapeAssert hasAlpha() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Shape)this.actual).hasAlpha()).overridingErrorMessage("Expected to have alpha but did not.", new Object[0])).isTrue();
        return this;
    }

    public ShapeAssert hasNoAlpha() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Shape)this.actual).hasAlpha()).overridingErrorMessage("Expected to not have alpha but did.", new Object[0])).isFalse();
        return this;
    }
}

