/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics.drawable;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import org.assertj.android.api.graphics.drawable.AbstractDrawableAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class BitmapDrawableAssert
extends AbstractDrawableAssert<BitmapDrawableAssert, BitmapDrawable> {
    public BitmapDrawableAssert(BitmapDrawable actual) {
        super(actual, BitmapDrawableAssert.class);
    }

    public BitmapDrawableAssert hasBitmap(Bitmap bitmap) {
        this.isNotNull();
        Bitmap actualBitmap = ((BitmapDrawable)this.actual).getBitmap();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualBitmap).overridingErrorMessage("Expected bitmap <%s> but was <%s>.", new Object[]{bitmap, actualBitmap})).isEqualTo((Object)bitmap);
        return this;
    }

    public BitmapDrawableAssert hasGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((BitmapDrawable)this.actual).getGravity();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return this;
    }

    public BitmapDrawableAssert hasPaint(Paint paint) {
        this.isNotNull();
        Paint actualPaint = ((BitmapDrawable)this.actual).getPaint();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualPaint).overridingErrorMessage("Expected paint <%s> but was <%s>.", new Object[]{paint, actualPaint})).isEqualTo((Object)paint);
        return this;
    }

    public BitmapDrawableAssert hasTileModeX(Shader.TileMode mode) {
        this.isNotNull();
        Shader.TileMode actualMode = ((BitmapDrawable)this.actual).getTileModeX();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualMode).overridingErrorMessage("Expected X tile mode <%s> but was <%s>.", new Object[]{mode, actualMode})).isEqualTo((Object)mode);
        return this;
    }

    public BitmapDrawableAssert hasTileModeY(Shader.TileMode mode) {
        this.isNotNull();
        Shader.TileMode actualMode = ((BitmapDrawable)this.actual).getTileModeY();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualMode).overridingErrorMessage("Expected Y tile mode <%s> but was <%s>.", new Object[]{mode, actualMode})).isEqualTo((Object)mode);
        return this;
    }
}

