/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics.drawable;

import android.graphics.drawable.AnimationDrawable;
import org.assertj.android.api.graphics.drawable.AbstractDrawableAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class AnimationDrawableAssert
extends AbstractDrawableAssert<AnimationDrawableAssert, AnimationDrawable> {
    public AnimationDrawableAssert(AnimationDrawable actual) {
        super(actual, AnimationDrawableAssert.class);
    }

    public AnimationDrawableAssert hasFrameCount(int count) {
        this.isNotNull();
        int actualCount = ((AnimationDrawable)this.actual).getNumberOfFrames();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected frame count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AnimationDrawableAssert isOneShot() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isOneShot()).overridingErrorMessage("Expected to be one-short but was not.", new Object[0])).isTrue();
        return this;
    }

    public AnimationDrawableAssert isNotOneShot() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isOneShot()).overridingErrorMessage("Expected to not be one-shot but was.", new Object[0])).isFalse();
        return this;
    }

    public AnimationDrawableAssert isRunning() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isRunning()).overridingErrorMessage("Expected to be running but was not.", new Object[0])).isTrue();
        return this;
    }

    public AnimationDrawableAssert isNotRunning() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isRunning()).overridingErrorMessage("Expected to not be running but was.", new Object[0])).isFalse();
        return this;
    }
}

