/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.graphics.Rect;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class RectAssert
extends AbstractAssert<RectAssert, Rect> {
    public RectAssert(Rect actual) {
        super((Object)actual, RectAssert.class);
    }

    public RectAssert hasBottom(int bottom) {
        this.isNotNull();
        int actualBottom = ((Rect)this.actual).bottom;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualBottom).overridingErrorMessage("Expected bottom <%s> but was <%s>.", new Object[]{bottom, actualBottom})).isEqualTo(bottom);
        return this;
    }

    public RectAssert hasLeft(int left) {
        this.isNotNull();
        int actualLeft = ((Rect)this.actual).left;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualLeft).overridingErrorMessage("Expected left <%s> but was <%s>.", new Object[]{left, actualLeft})).isEqualTo(left);
        return this;
    }

    public RectAssert hasRight(int right) {
        this.isNotNull();
        int actualRight = ((Rect)this.actual).right;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRight).overridingErrorMessage("Expected right <%s> but was <%s>.", new Object[]{right, actualRight})).isEqualTo(right);
        return this;
    }

    public RectAssert hasTop(int top) {
        this.isNotNull();
        int actualTop = ((Rect)this.actual).top;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualTop).overridingErrorMessage("Expected top <%s> but was <%s>.", new Object[]{top, actualTop})).isEqualTo(top);
        return this;
    }

    public RectAssert hasCenterX(int center) {
        this.isNotNull();
        int actualCenter = ((Rect)this.actual).centerX();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCenter).overridingErrorMessage("Expected X center <%s> but was <%s>.", new Object[]{center, actualCenter})).isEqualTo(center);
        return this;
    }

    public RectAssert hasCenterY(int center) {
        this.isNotNull();
        int actualCenter = ((Rect)this.actual).centerY();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCenter).overridingErrorMessage("Expected Y center <%s> but was <%s>.", new Object[]{center, actualCenter})).isEqualTo(center);
        return this;
    }

    public RectAssert hasExactCenterX(float center) {
        this.isNotNull();
        float actualCenter = ((Rect)this.actual).exactCenterX();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualCenter).overridingErrorMessage("Expected exact X center <%s> but was <%s>.", new Object[]{Float.valueOf(center), Float.valueOf(actualCenter)})).isEqualTo(center);
        return this;
    }

    public RectAssert hasExactCenterY(float center) {
        this.isNotNull();
        float actualCenter = ((Rect)this.actual).exactCenterY();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualCenter).overridingErrorMessage("Expected exact Y center <%s> but was <%s>.", new Object[]{Float.valueOf(center), Float.valueOf(actualCenter)})).isEqualTo(center);
        return this;
    }

    public RectAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Rect)this.actual).height();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public RectAssert isEmpty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Rect)this.actual).isEmpty()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isTrue();
        return this;
    }

    public RectAssert isNotEmpty() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Rect)this.actual).isEmpty()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isFalse();
        return this;
    }

    public RectAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Rect)this.actual).width();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }
}

