/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.graphics;

import android.graphics.Movie;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class MovieAssert
extends AbstractAssert<MovieAssert, Movie> {
    public MovieAssert(Movie actual) {
        super((Object)actual, MovieAssert.class);
    }

    public MovieAssert hasDuration(int duration) {
        this.isNotNull();
        int actualDuration = ((Movie)this.actual).duration();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return this;
    }

    public MovieAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Movie)this.actual).height();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public MovieAssert isOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Movie)this.actual).isOpaque()).overridingErrorMessage("Expected to be opaque but was not.", new Object[0])).isTrue();
        return this;
    }

    public MovieAssert isNotOpaque() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Movie)this.actual).isOpaque()).overridingErrorMessage("Expected to not be opaque but was.", new Object[0])).isFalse();
        return this;
    }

    public MovieAssert hasWidth(int width) {
        this.isNotNull();
        int actualHeight = ((Movie)this.actual).width();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return this;
    }
}

