/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.gesture;

import android.gesture.GestureOverlayView;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class GestureOverlayViewAssert
extends AbstractFrameLayoutAssert<GestureOverlayViewAssert, GestureOverlayView> {
    public GestureOverlayViewAssert(GestureOverlayView actual) {
        super(actual, GestureOverlayViewAssert.class);
    }

    public GestureOverlayViewAssert hasFadeOffset(long offset) {
        this.isNotNull();
        long actualOffset = ((GestureOverlayView)this.actual).getFadeOffset();
        ((AbstractLongAssert)Assertions.assertThat((long)actualOffset).overridingErrorMessage("Expected fade offset <%s> but was <%s>.", new Object[]{offset, actualOffset})).isEqualTo(offset);
        return this;
    }

    public GestureOverlayViewAssert hasGestureColor(int color) {
        this.isNotNull();
        int actualColor = ((GestureOverlayView)this.actual).getGestureColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected gesture color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeAngleThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeAngleThreshold();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke angle threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeLengthThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeLengthThreshold();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke length threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeSquarenessThreshold(float threshold) {
        this.isNotNull();
        float actualThreshold = ((GestureOverlayView)this.actual).getGestureStrokeSquarenessTreshold();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualThreshold).overridingErrorMessage("Expected gesture stroke squareness threshold <%s> but was <%s>.", new Object[]{Float.valueOf(threshold), Float.valueOf(actualThreshold)})).isEqualTo(threshold);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStokeType(int type) {
        this.isNotNull();
        int actualType = ((GestureOverlayView)this.actual).getGestureStrokeType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected gesture stroke type <%s> but was <%s>.", new Object[]{GestureOverlayViewAssert.gestureStrokeTypeToString(type), GestureOverlayViewAssert.gestureStrokeTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public GestureOverlayViewAssert hasGestureStrokeWidth(float width) {
        this.isNotNull();
        float actualWidth = ((GestureOverlayView)this.actual).getGestureStrokeWidth();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualWidth).overridingErrorMessage("Expected gesture stroke width <%s> but was <%s>.", new Object[]{Float.valueOf(width), Float.valueOf(actualWidth)})).isEqualTo(width);
        return this;
    }

    public GestureOverlayViewAssert hasOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((GestureOverlayView)this.actual).getOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{GestureOverlayViewAssert.orientationToString(orientation), GestureOverlayViewAssert.orientationToString(actualOrientation)})).isEqualTo(orientation);
        return this;
    }

    public GestureOverlayViewAssert hasUncertainGestureColor(int color) {
        this.isNotNull();
        int actualColor = ((GestureOverlayView)this.actual).getUncertainGestureColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected uncertain gesture color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public GestureOverlayViewAssert isInterceptingEvents() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isEventsInterceptionEnabled()).overridingErrorMessage("Expected to be intercepting events but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isNotInterceptingEvents() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isEventsInterceptionEnabled()).overridingErrorMessage("Expected to not be intercepting events but was.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isFadeEnabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isFadeEnabled()).overridingErrorMessage("Expected to have fade enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isFadeDisabled() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isFadeEnabled()).overridingErrorMessage("Expected to have fade disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isGestureVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGestureVisible()).overridingErrorMessage("Expected gesture to be visible but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isGestureNotVisible() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGestureVisible()).overridingErrorMessage("Expected gesture to not be visible but was.", new Object[0])).isFalse();
        return this;
    }

    public GestureOverlayViewAssert isGesturing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGesturing()).overridingErrorMessage("Expected to be gesturing but was not.", new Object[0])).isTrue();
        return this;
    }

    public GestureOverlayViewAssert isNotGesturing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((GestureOverlayView)this.actual).isGesturing()).overridingErrorMessage("Expected to not be gesturing but was.", new Object[0])).isFalse();
        return this;
    }

    public static String gestureStrokeTypeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(0, "single").value(1, "multiple").get();
    }

    public static String orientationToString(int orientation) {
        return IntegerUtils.buildNamedValueString(orientation).value(0, "horizontal").value(1, "vertical").get();
    }
}

