/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.content;

import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;

public class ContentValuesEntry {
    private final String key;
    private final Object value;

    public static ContentValuesEntry entry(String key, Object value) {
        return new ContentValuesEntry(key, value);
    }

    private ContentValuesEntry(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentValuesEntry other = (ContentValuesEntry)obj;
        return Objects.areEqual((Object)this.key, (Object)other.key) && Objects.areEqual((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor((Object)this.key);
        result = 31 * result + Objects.hashCodeFor((Object)this.value);
        return result;
    }

    public String toString() {
        return String.format("%s[key=%s, value=%s]", this.getClass().getSimpleName(), Strings.quote((String)this.key), Strings.quote((Object)this.value));
    }
}

