/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.content;

import android.content.ContentValues;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.android.api.content.ContentValuesEntry;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.Objects;

public class ContentValuesAssert
extends AbstractAssert<ContentValuesAssert, ContentValues> {
    public ContentValuesAssert(ContentValues actual) {
        super((Object)actual, ContentValuesAssert.class);
    }

    public ContentValuesAssert isEmpty() {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((ContentValues)this.actual).size()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isZero();
        return this;
    }

    public ContentValuesAssert isNotEmpty() {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((ContentValues)this.actual).size()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isNotZero();
        return this;
    }

    public ContentValuesAssert containsKey(String key) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ContentValues)this.actual).containsKey(key)).overridingErrorMessage("Expected key <%s> but was not found.", new Object[]{key})).isTrue();
        return this;
    }

    public ContentValuesAssert containsValue(Object expectedValue) {
        this.isNotNull();
        Set entries = ((ContentValues)this.actual).valueSet();
        ArrayList values = new ArrayList(entries.size());
        for (Map.Entry entry : entries) {
            values.add(entry.getValue());
        }
        ((AbstractListAssert)Assertions.assertThat(values).overridingErrorMessage("Expected <%s> but was not found.", new Object[]{expectedValue})).contains(new Object[]{expectedValue});
        return this;
    }

    public ContentValuesAssert contains(ContentValuesEntry ... entries) {
        this.isNotEmptyOrNull(entries);
        LinkedHashSet<ContentValuesEntry> notFound = new LinkedHashSet<ContentValuesEntry>();
        for (ContentValuesEntry entry : entries) {
            if (this.containsEntry((ContentValues)this.actual, entry)) continue;
            notFound.add(entry);
        }
        if (!notFound.isEmpty()) {
            throw Failures.instance().failure((AssertionInfo)new WritableAssertionInfo(), ShouldContain.shouldContain((Object)this.actual, (Object)entries, notFound));
        }
        return this;
    }

    public ContentValuesAssert hasSize(int expected) {
        this.isNotNull();
        int size = ((ContentValues)this.actual).size();
        ((AbstractIntegerAssert)Assertions.assertThat((int)size).overridingErrorMessage("Expected size <%d> but was <%d>.", new Object[]{expected, size})).isEqualTo(expected);
        return this;
    }

    private void isNotEmptyOrNull(ContentValuesEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("The array of entries to look for should not be null");
        }
        if (entries.length == 0) {
            throw new IllegalArgumentException("The array of entries to look for should not be empty");
        }
    }

    private boolean containsEntry(ContentValues actual, ContentValuesEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entries to look for should not be null");
        }
        String key = entry.getKey();
        if (!actual.containsKey(key)) {
            return false;
        }
        return Objects.areEqual((Object)actual.get(key), (Object)entry.getValue());
    }
}

