/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattDescriptor;
import java.util.Arrays;
import java.util.UUID;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=18)
public class BluetoothGattDescriptorAssert
extends AbstractAssert<BluetoothGattDescriptorAssert, BluetoothGattDescriptor> {
    public BluetoothGattDescriptorAssert(BluetoothGattDescriptor actual) {
        super((Object)actual, BluetoothGattDescriptorAssert.class);
    }

    public BluetoothGattDescriptorAssert hasPermissions(int permissions) {
        this.isNotNull();
        int actualPermissions = ((BluetoothGattDescriptor)this.actual).getPermissions();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPermissions).overridingErrorMessage("Expected permissions <%s> but was <%s>.", new Object[]{BluetoothGattDescriptorAssert.permissionsToString(permissions), BluetoothGattDescriptorAssert.permissionsToString(actualPermissions)})).isEqualTo(permissions);
        return this;
    }

    public BluetoothGattDescriptorAssert hasUuid(UUID uuid) {
        this.isNotNull();
        UUID actualUuid = ((BluetoothGattDescriptor)this.actual).getUuid();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)uuid).overridingErrorMessage("Expected UUID <%s> but was <%s>.", new Object[]{uuid, actualUuid})).isEqualTo((Object)uuid);
        return this;
    }

    public BluetoothGattDescriptorAssert hasValue(byte[] value) {
        this.isNotNull();
        byte[] actualValue = ((BluetoothGattDescriptor)this.actual).getValue();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualValue).overridingErrorMessage("Expected value <%s> but was <%s>.", new Object[]{Arrays.toString(value), Arrays.toString(actualValue)})).isEqualTo((Object)value);
        return this;
    }

    public static String permissionsToString(int permissions) {
        return IntegerUtils.buildBitMaskString(permissions).flag(1, "read").flag(2, "read_encrypted").flag(4, "read_encrypted_mitm").flag(16, "write").flag(32, "write_encrypted").flag(64, "write_encrypted_mitm").flag(128, "write_signed").flag(256, "write_signed_mitm").get();
    }
}

