/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.app;

import android.annotation.TargetApi;
import android.app.UiModeManager;
import org.assertj.android.api.content.res.ConfigurationAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=8)
public class UiModeManagerAssert
extends AbstractAssert<UiModeManagerAssert, UiModeManager> {
    public UiModeManagerAssert(UiModeManager actual) {
        super((Object)actual, UiModeManagerAssert.class);
    }

    public UiModeManagerAssert isNightMode() {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((UiModeManager)this.actual).getNightMode()).overridingErrorMessage("Expected to be in night mode but was not in night mode.", new Object[0])).isNotEqualTo(1);
        return this;
    }

    public UiModeManagerAssert isNotNightMode() {
        this.isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((UiModeManager)this.actual).getNightMode()).overridingErrorMessage("Expected not to be in night mode but was in night mode.", new Object[0])).isEqualTo(1);
        return this;
    }

    public UiModeManagerAssert isInUiModeType(int mode) {
        this.isNotNull();
        int actualMode = ((UiModeManager)this.actual).getCurrentModeType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected mode <%s> but was <%s>.", new Object[]{ConfigurationAssert.uiModeTypeToString(mode), ConfigurationAssert.uiModeTypeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public UiModeManagerAssert isNotInUiModeType(int mode) {
        this.isNotNull();
        int actualMode = ((UiModeManager)this.actual).getCurrentModeType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected not mode <%s> but was <%s>.", new Object[]{ConfigurationAssert.uiModeTypeToString(mode), ConfigurationAssert.uiModeTypeToString(actualMode)})).isNotEqualTo(mode);
        return this;
    }
}

