/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.app;

import android.annotation.TargetApi;
import android.app.Activity;
import org.assertj.android.api.content.AbstractContextAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractActivityAssert<S extends AbstractActivityAssert<S, A>, A extends Activity>
extends AbstractContextAssert<S, A> {
    public AbstractActivityAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasRequestedOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((Activity)this.actual).getRequestedOrientation();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{AbstractActivityAssert.screenOrientationToString(orientation), AbstractActivityAssert.screenOrientationToString(actualOrientation)})).isEqualTo(orientation);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((Activity)this.actual).getTitle();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasTitle(int resId) {
        this.isNotNull();
        return this.hasTitle(((Activity)this.actual).getString(resId));
    }

    public S hasTitleColor(int color) {
        this.isNotNull();
        int actualColor = ((Activity)this.actual).getTitleColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected title color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasWindowFocus() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to have focus but was not focused.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isChangingConfigurations() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChangingConfigurations()).overridingErrorMessage("Expected changing configurations but was not changing.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=11)
    public S isNotChangingConfigurations() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChangingConfigurations()).overridingErrorMessage("Expected not to be changing configurations but was changing.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isChild() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChild()).overridingErrorMessage("Expected to be a child but was not a child.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotChild() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChild()).overridingErrorMessage("Expected not to be a child but was a child.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=17)
    public S isDestroyed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isDestroyed()).overridingErrorMessage("Expected to be destroyed but was not destroyed.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=17)
    public S isNotDestroyed() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isDestroyed()).overridingErrorMessage("Expected not to be destroyed but was destroyed.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isFinishing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isFinishing()).overridingErrorMessage("Expected to be finishing but was not finishing.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotFinishing() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isFinishing()).overridingErrorMessage("Expected to not be finishing but was finishing.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isImmersive() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isImmersive()).overridingErrorMessage("Expected to be immersive but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    @TargetApi(value=18)
    public S isNotImmersive() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isImmersive()).overridingErrorMessage("Expected to not be immersive but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isTaskRoot() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isTaskRoot()).overridingErrorMessage("Expected to be task root but was not task root.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotTaskRoot() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isTaskRoot()).overridingErrorMessage("Expected not to be task root but was task root.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public static String screenOrientationToString(int orientation) {
        return IntegerUtils.buildNamedValueString(orientation).value(-1, "unspecified").value(0, "landscape").value(1, "portrait").value(2, "user").value(3, "behind").value(4, "sensor").value(5, "nosensor").value(6, "sensor_landscape").value(7, "sensor_portrait").value(8, "reverse_landscape").value(9, "reverse_portrait").value(10, "full_sensor").value(11, "user_landscape").value(12, "user_portrait").value(13, "full_user").value(14, "locked").get();
    }
}

