/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.animation;

import android.animation.Keyframe;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class KeyframeAssert
extends AbstractAssert<KeyframeAssert, Keyframe> {
    public KeyframeAssert(Keyframe actual) {
        super((Object)actual, KeyframeAssert.class);
    }

    public KeyframeAssert hasFraction(float fraction) {
        this.isNotNull();
        float actualFraction = ((Keyframe)this.actual).getFraction();
        ((AbstractFloatAssert)Assertions.assertThat((float)actualFraction).overridingErrorMessage("Expected fraction <%s> but was <%s>.", new Object[]{Float.valueOf(fraction), Float.valueOf(actualFraction)})).isEqualTo(fraction);
        return this;
    }

    public KeyframeAssert hasInterpolator(TimeInterpolator interpolator) {
        this.isNotNull();
        TimeInterpolator actualInterpolator = ((Keyframe)this.actual).getInterpolator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return this;
    }

    public KeyframeAssert hasType(Class type) {
        this.isNotNull();
        Class actualType = ((Keyframe)this.actual).getType();
        ((AbstractClassAssert)Assertions.assertThat((Class)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo((Object)type);
        return this;
    }

    public KeyframeAssert hasValue(Object value) {
        this.isNotNull();
        Object actualValue = ((Keyframe)this.actual).getValue();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualValue).overridingErrorMessage("Expected value <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }
}

